/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentTypesFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListComponentTypesFilter> {
    private static final SdkField<String> EXTENDS_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("extendsFrom").getter(ListComponentTypesFilter.getter(ListComponentTypesFilter::extendsFrom)).setter(ListComponentTypesFilter.setter(Builder::extendsFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListComponentTypesFilter.getter(ListComponentTypesFilter::namespace)).setter(ListComponentTypesFilter.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<Boolean> IS_ABSTRACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAbstract").getter(ListComponentTypesFilter.getter(ListComponentTypesFilter::isAbstract)).setter(ListComponentTypesFilter.setter(Builder::isAbstract)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAbstract").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENDS_FROM_FIELD, NAMESPACE_FIELD, IS_ABSTRACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("extendsFrom", EXTENDS_FROM_FIELD);
            this.put("namespace", NAMESPACE_FIELD);
            this.put("isAbstract", IS_ABSTRACT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String extendsFrom;
    private final String namespace;
    private final Boolean isAbstract;
    private final Type type;

    private ListComponentTypesFilter(BuilderImpl builder) {
        this.extendsFrom = builder.extendsFrom;
        this.namespace = builder.namespace;
        this.isAbstract = builder.isAbstract;
        this.type = builder.type;
    }

    public final String extendsFrom() {
        return this.extendsFrom;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Boolean isAbstract() {
        return this.isAbstract;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extendsFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAbstract());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentTypesFilter)) {
            return false;
        }
        ListComponentTypesFilter other = (ListComponentTypesFilter)obj;
        return Objects.equals(this.extendsFrom(), other.extendsFrom()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.isAbstract(), other.isAbstract());
    }

    public final String toString() {
        return ToString.builder((String)"ListComponentTypesFilter").add("ExtendsFrom", (Object)this.extendsFrom()).add("Namespace", (Object)this.namespace()).add("IsAbstract", (Object)this.isAbstract()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extendsFrom": {
                return Optional.ofNullable(clazz.cast(this.extendsFrom()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "isAbstract": {
                return Optional.ofNullable(clazz.cast(this.isAbstract()));
            }
        }
        return Optional.empty();
    }

    public static ListComponentTypesFilter fromExtendsFrom(String extendsFrom) {
        return (ListComponentTypesFilter)ListComponentTypesFilter.builder().extendsFrom(extendsFrom).build();
    }

    public static ListComponentTypesFilter fromNamespace(String namespace) {
        return (ListComponentTypesFilter)ListComponentTypesFilter.builder().namespace(namespace).build();
    }

    public static ListComponentTypesFilter fromIsAbstract(Boolean isAbstract) {
        return (ListComponentTypesFilter)ListComponentTypesFilter.builder().isAbstract(isAbstract).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentTypesFilter, T> g) {
        return obj -> g.apply((ListComponentTypesFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EXTENDS_FROM,
        NAMESPACE,
        IS_ABSTRACT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String extendsFrom;
        private String namespace;
        private Boolean isAbstract;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentTypesFilter model) {
            this.extendsFrom(model.extendsFrom);
            this.namespace(model.namespace);
            this.isAbstract(model.isAbstract);
        }

        public final String getExtendsFrom() {
            return this.extendsFrom;
        }

        public final void setExtendsFrom(String extendsFrom) {
            String oldValue = this.extendsFrom;
            this.extendsFrom = extendsFrom;
            this.handleUnionValueChange(Type.EXTENDS_FROM, oldValue, this.extendsFrom);
        }

        @Override
        public final Builder extendsFrom(String extendsFrom) {
            String oldValue = this.extendsFrom;
            this.extendsFrom = extendsFrom;
            this.handleUnionValueChange(Type.EXTENDS_FROM, oldValue, this.extendsFrom);
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            String oldValue = this.namespace;
            this.namespace = namespace;
            this.handleUnionValueChange(Type.NAMESPACE, oldValue, this.namespace);
        }

        @Override
        public final Builder namespace(String namespace) {
            String oldValue = this.namespace;
            this.namespace = namespace;
            this.handleUnionValueChange(Type.NAMESPACE, oldValue, this.namespace);
            return this;
        }

        public final Boolean getIsAbstract() {
            return this.isAbstract;
        }

        public final void setIsAbstract(Boolean isAbstract) {
            Boolean oldValue = this.isAbstract;
            this.isAbstract = isAbstract;
            this.handleUnionValueChange(Type.IS_ABSTRACT, oldValue, this.isAbstract);
        }

        @Override
        public final Builder isAbstract(Boolean isAbstract) {
            Boolean oldValue = this.isAbstract;
            this.isAbstract = isAbstract;
            this.handleUnionValueChange(Type.IS_ABSTRACT, oldValue, this.isAbstract);
            return this;
        }

        public ListComponentTypesFilter build() {
            return new ListComponentTypesFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListComponentTypesFilter> {
        public Builder extendsFrom(String var1);

        public Builder namespace(String var1);

        public Builder isAbstract(Boolean var1);
    }
}

