/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.SyncJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSyncJobResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetSyncJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSyncJobResponse.getter(GetSyncJobResponse::arn)).setter(GetSyncJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetSyncJobResponse.getter(GetSyncJobResponse::workspaceId)).setter(GetSyncJobResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(GetSyncJobResponse.getter(GetSyncJobResponse::syncSource)).setter(GetSyncJobResponse.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()}).build();
    private static final SdkField<String> SYNC_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncRole").getter(GetSyncJobResponse.getter(GetSyncJobResponse::syncRole)).setter(GetSyncJobResponse.setter(Builder::syncRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncRole").build()}).build();
    private static final SdkField<SyncJobStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GetSyncJobResponse.getter(GetSyncJobResponse::status)).setter(GetSyncJobResponse.setter(Builder::status)).constructor(SyncJobStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(GetSyncJobResponse.getter(GetSyncJobResponse::creationDateTime)).setter(GetSyncJobResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateDateTime").getter(GetSyncJobResponse.getter(GetSyncJobResponse::updateDateTime)).setter(GetSyncJobResponse.setter(Builder::updateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WORKSPACE_ID_FIELD, SYNC_SOURCE_FIELD, SYNC_ROLE_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, UPDATE_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("workspaceId", WORKSPACE_ID_FIELD);
            this.put("syncSource", SYNC_SOURCE_FIELD);
            this.put("syncRole", SYNC_ROLE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("updateDateTime", UPDATE_DATE_TIME_FIELD);
        }
    });
    private final String arn;
    private final String workspaceId;
    private final String syncSource;
    private final String syncRole;
    private final SyncJobStatus status;
    private final Instant creationDateTime;
    private final Instant updateDateTime;

    private GetSyncJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.workspaceId = builder.workspaceId;
        this.syncSource = builder.syncSource;
        this.syncRole = builder.syncRole;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.updateDateTime = builder.updateDateTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    public final String syncRole() {
        return this.syncRole;
    }

    public final SyncJobStatus status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant updateDateTime() {
        return this.updateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSyncJobResponse)) {
            return false;
        }
        GetSyncJobResponse other = (GetSyncJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.syncSource(), other.syncSource()) && Objects.equals(this.syncRole(), other.syncRole()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.updateDateTime(), other.updateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetSyncJobResponse").add("Arn", (Object)this.arn()).add("WorkspaceId", (Object)this.workspaceId()).add("SyncSource", (Object)this.syncSource()).add("SyncRole", (Object)this.syncRole()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("UpdateDateTime", (Object)this.updateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
            case "syncRole": {
                return Optional.ofNullable(clazz.cast(this.syncRole()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "updateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSyncJobResponse, T> g) {
        return obj -> g.apply((GetSyncJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String workspaceId;
        private String syncSource;
        private String syncRole;
        private SyncJobStatus status;
        private Instant creationDateTime;
        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSyncJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.workspaceId(model.workspaceId);
            this.syncSource(model.syncSource);
            this.syncRole(model.syncRole);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.updateDateTime(model.updateDateTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getSyncRole() {
            return this.syncRole;
        }

        public final void setSyncRole(String syncRole) {
            this.syncRole = syncRole;
        }

        @Override
        public final Builder syncRole(String syncRole) {
            this.syncRole = syncRole;
            return this;
        }

        public final SyncJobStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(SyncJobStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SyncJobStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public GetSyncJobResponse build() {
            return new GetSyncJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSyncJobResponse> {
        public Builder arn(String var1);

        public Builder workspaceId(String var1);

        public Builder syncSource(String var1);

        public Builder syncRole(String var1);

        public Builder status(SyncJobStatus var1);

        default public Builder status(Consumer<SyncJobStatus.Builder> status) {
            return this.status((SyncJobStatus)((SyncJobStatus.Builder)SyncJobStatus.builder().applyMutation(status)).build());
        }

        public Builder creationDateTime(Instant var1);

        public Builder updateDateTime(Instant var1);
    }
}

