/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentSummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentSummary;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentsResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListComponentsResponse> {
    private static final SdkField<List<ComponentSummary>> COMPONENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentSummaries").getter(ListComponentsResponse.getter(ListComponentsResponse::componentSummaries)).setter(ListComponentsResponse.setter(Builder::componentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComponentsResponse.getter(ListComponentsResponse::nextToken)).setter(ListComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("componentSummaries", COMPONENT_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ComponentSummary> componentSummaries;
    private final String nextToken;

    private ListComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.componentSummaries = builder.componentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComponentSummaries() {
        return this.componentSummaries != null && !(this.componentSummaries instanceof SdkAutoConstructList);
    }

    public final List<ComponentSummary> componentSummaries() {
        return this.componentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentSummaries() ? this.componentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsResponse)) {
            return false;
        }
        ListComponentsResponse other = (ListComponentsResponse)((Object)obj);
        return this.hasComponentSummaries() == other.hasComponentSummaries() && Objects.equals(this.componentSummaries(), other.componentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComponentsResponse").add("ComponentSummaries", this.hasComponentSummaries() ? this.componentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentSummaries": {
                return Optional.ofNullable(clazz.cast(this.componentSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentsResponse, T> g) {
        return obj -> g.apply((ListComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<ComponentSummary> componentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentsResponse model) {
            super(model);
            this.componentSummaries(model.componentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ComponentSummary.Builder> getComponentSummaries() {
            List<ComponentSummary.Builder> result = ComponentSummariesCopier.copyToBuilder(this.componentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentSummaries(Collection<ComponentSummary.BuilderImpl> componentSummaries) {
            this.componentSummaries = ComponentSummariesCopier.copyFromBuilder(componentSummaries);
        }

        @Override
        public final Builder componentSummaries(Collection<ComponentSummary> componentSummaries) {
            this.componentSummaries = ComponentSummariesCopier.copy(componentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentSummaries(ComponentSummary ... componentSummaries) {
            this.componentSummaries(Arrays.asList(componentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentSummaries(Consumer<ComponentSummary.Builder> ... componentSummaries) {
            this.componentSummaries(Stream.of(componentSummaries).map(c -> (ComponentSummary)((ComponentSummary.Builder)ComponentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComponentsResponse build() {
            return new ListComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComponentsResponse> {
        public Builder componentSummaries(Collection<ComponentSummary> var1);

        public Builder componentSummaries(ComponentSummary ... var1);

        public Builder componentSummaries(Consumer<ComponentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

