/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.model.AccessDeniedException;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ConflictException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorFailureException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.InternalServerException;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerException;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.QueryTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iottwinmaker.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ThrottlingException;
import software.amazon.awssdk.services.iottwinmaker.model.TooManyTagsException;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ValidationException;
import software.amazon.awssdk.services.iottwinmaker.paginators.ExecuteQueryIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueHistoryIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.GetPropertyValueIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListComponentTypesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListEntitiesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListScenesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncJobsIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListSyncResourcesIterable;
import software.amazon.awssdk.services.iottwinmaker.paginators.ListWorkspacesIterable;
import software.amazon.awssdk.services.iottwinmaker.transform.BatchPutPropertyValuesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ExecuteQueryRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPricingPlanRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListComponentTypesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListScenesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListSyncResourcesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateWorkspaceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultIoTTwinMakerClient
implements IoTTwinMakerClient {
    private static final Logger log = Logger.loggerFor(DefaultIoTTwinMakerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTTwinMakerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iottwinmaker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutPropertyValuesResponse batchPutPropertyValues(BatchPutPropertyValuesRequest batchPutPropertyValuesRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutPropertyValuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, batchPutPropertyValuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchPutPropertyValues");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";
            BatchPutPropertyValuesResponse batchPutPropertyValuesResponse = (BatchPutPropertyValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutPropertyValues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchPutPropertyValuesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchPutPropertyValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchPutPropertyValuesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$batchPutPropertyValues$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComponentTypeResponse createComponentType(CreateComponentTypeRequest createComponentTypeRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateComponentTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, createComponentTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            CreateComponentTypeResponse createComponentTypeResponse = (CreateComponentTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComponentType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createComponentTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateComponentTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createComponentTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$createComponentType$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEntityResponse createEntity(CreateEntityRequest createEntityRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEntityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, createEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            CreateEntityResponse createEntityResponse = (CreateEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEntity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$createEntity$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSceneResponse createScene(CreateSceneRequest createSceneRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSceneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, createSceneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            CreateSceneResponse createSceneResponse = (CreateSceneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScene").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createSceneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSceneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSceneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$createScene$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSyncJobResponse createSyncJob(CreateSyncJobRequest createSyncJobRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, createSyncJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSyncJob");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            CreateSyncJobResponse createSyncJobResponse = (CreateSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createSyncJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSyncJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$createSyncJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, createWorkspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            CreateWorkspaceResponse createWorkspaceResponse = (CreateWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createWorkspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$createWorkspace$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteComponentTypeResponse deleteComponentType(DeleteComponentTypeRequest deleteComponentTypeRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteComponentTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteComponentTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            DeleteComponentTypeResponse deleteComponentTypeResponse = (DeleteComponentTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteComponentType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteComponentTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteComponentTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteComponentTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$deleteComponentType$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEntityResponse deleteEntity(DeleteEntityRequest deleteEntityRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEntityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            DeleteEntityResponse deleteEntityResponse = (DeleteEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEntity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$deleteEntity$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSceneResponse deleteScene(DeleteSceneRequest deleteSceneRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSceneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteSceneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            DeleteSceneResponse deleteSceneResponse = (DeleteSceneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScene").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteSceneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSceneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSceneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$deleteScene$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSyncJobResponse deleteSyncJob(DeleteSyncJobRequest deleteSyncJobRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteSyncJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSyncJob");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            DeleteSyncJobResponse deleteSyncJobResponse = (DeleteSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteSyncJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSyncJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$deleteSyncJob$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkspaceResponse deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            DeleteWorkspaceResponse deleteWorkspaceResponse = (DeleteWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteWorkspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$deleteWorkspace$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteQueryResponse executeQuery(ExecuteQueryRequest executeQueryRequest) throws InternalServerException, AccessDeniedException, QueryTimeoutException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteQueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, executeQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteQuery");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ExecuteQueryResponse executeQueryResponse = (ExecuteQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteQuery").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)executeQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$executeQuery$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ExecuteQueryIterable executeQueryPaginator(ExecuteQueryRequest executeQueryRequest) throws InternalServerException, AccessDeniedException, QueryTimeoutException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ExecuteQueryIterable(this, this.applyPaginatorUserAgent(executeQueryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComponentTypeResponse getComponentType(GetComponentTypeRequest getComponentTypeRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetComponentTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getComponentTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            GetComponentTypeResponse getComponentTypeResponse = (GetComponentTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComponentType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getComponentTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetComponentTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getComponentTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getComponentType$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEntityResponse getEntity(GetEntityRequest getEntityRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEntityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            GetEntityResponse getEntityResponse = (GetEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEntity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getEntity$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPricingPlanResponse getPricingPlan(GetPricingPlanRequest getPricingPlanRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPricingPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getPricingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPricingPlan");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            GetPricingPlanResponse getPricingPlanResponse = (GetPricingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPricingPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getPricingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPricingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPricingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getPricingPlan$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertyValueResponse getPropertyValue(GetPropertyValueRequest getPropertyValueRequest) throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPropertyValueResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getPropertyValueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPropertyValue");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";
            GetPropertyValueResponse getPropertyValueResponse = (GetPropertyValueResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPropertyValue").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getPropertyValueRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPropertyValueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPropertyValueResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getPropertyValue$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetPropertyValueIterable getPropertyValuePaginator(GetPropertyValueRequest getPropertyValueRequest) throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new GetPropertyValueIterable(this, this.applyPaginatorUserAgent(getPropertyValueRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPropertyValueHistoryResponse getPropertyValueHistory(GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPropertyValueHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getPropertyValueHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPropertyValueHistory");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";
            GetPropertyValueHistoryResponse getPropertyValueHistoryResponse = (GetPropertyValueHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPropertyValueHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getPropertyValueHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPropertyValueHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPropertyValueHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getPropertyValueHistory$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetPropertyValueHistoryIterable getPropertyValueHistoryPaginator(GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new GetPropertyValueHistoryIterable(this, this.applyPaginatorUserAgent(getPropertyValueHistoryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSceneResponse getScene(GetSceneRequest getSceneRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSceneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getSceneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            GetSceneResponse getSceneResponse = (GetSceneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetScene").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getSceneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSceneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSceneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getScene$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSyncJobResponse getSyncJob(GetSyncJobRequest getSyncJobRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getSyncJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSyncJob");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            GetSyncJobResponse getSyncJobResponse = (GetSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getSyncJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSyncJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getSyncJob$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkspaceResponse getWorkspace(GetWorkspaceRequest getWorkspaceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, getWorkspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            GetWorkspaceResponse getWorkspaceResponse = (GetWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getWorkspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$getWorkspace$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListComponentTypesResponse listComponentTypes(ListComponentTypesRequest listComponentTypesRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListComponentTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listComponentTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListComponentTypes");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListComponentTypesResponse listComponentTypesResponse = (ListComponentTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListComponentTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listComponentTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListComponentTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listComponentTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listComponentTypes$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListComponentTypesIterable listComponentTypesPaginator(ListComponentTypesRequest listComponentTypesRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ListComponentTypesIterable(this, this.applyPaginatorUserAgent(listComponentTypesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntitiesResponse listEntities(ListEntitiesRequest listEntitiesRequest) throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntities");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListEntitiesResponse listEntitiesResponse = (ListEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listEntities$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEntitiesIterable listEntitiesPaginator(ListEntitiesRequest listEntitiesRequest) throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ListEntitiesIterable(this, this.applyPaginatorUserAgent(listEntitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListScenesResponse listScenes(ListScenesRequest listScenesRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScenesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listScenesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScenes");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListScenesResponse listScenesResponse = (ListScenesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScenes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listScenesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListScenesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listScenesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listScenes$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListScenesIterable listScenesPaginator(ListScenesRequest listScenesRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ListScenesIterable(this, this.applyPaginatorUserAgent(listScenesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSyncJobsResponse listSyncJobs(ListSyncJobsRequest listSyncJobsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSyncJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listSyncJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSyncJobs");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListSyncJobsResponse listSyncJobsResponse = (ListSyncJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSyncJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listSyncJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSyncJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSyncJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listSyncJobs$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSyncJobsIterable listSyncJobsPaginator(ListSyncJobsRequest listSyncJobsRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ListSyncJobsIterable(this, this.applyPaginatorUserAgent(listSyncJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSyncResourcesResponse listSyncResources(ListSyncResourcesRequest listSyncResourcesRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSyncResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listSyncResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSyncResources");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListSyncResourcesResponse listSyncResourcesResponse = (ListSyncResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSyncResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listSyncResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSyncResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSyncResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listSyncResources$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSyncResourcesIterable listSyncResourcesPaginator(ListSyncResourcesRequest listSyncResourcesRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ListSyncResourcesIterable(this, this.applyPaginatorUserAgent(listSyncResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listTagsForResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkspacesResponse listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkspacesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, listWorkspacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkspaces");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            ListWorkspacesResponse listWorkspacesResponse = (ListWorkspacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkspaces").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listWorkspacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkspacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkspacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$listWorkspaces$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkspacesIterable listWorkspacesPaginator(ListWorkspacesRequest listWorkspacesRequest) throws InternalServerException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        return new ListWorkspacesIterable(this, this.applyPaginatorUserAgent(listWorkspacesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateComponentTypeResponse updateComponentType(UpdateComponentTypeRequest updateComponentTypeRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateComponentTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, updateComponentTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            UpdateComponentTypeResponse updateComponentTypeResponse = (UpdateComponentTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateComponentType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateComponentTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateComponentTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateComponentTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$updateComponentType$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEntityResponse updateEntity(UpdateEntityRequest updateEntityRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEntityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, updateEntityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            UpdateEntityResponse updateEntityResponse = (UpdateEntityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEntity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateEntityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEntityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEntityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$updateEntity$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePricingPlanResponse updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest) throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePricingPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, updatePricingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePricingPlan");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            UpdatePricingPlanResponse updatePricingPlanResponse = (UpdatePricingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePricingPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updatePricingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePricingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePricingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$updatePricingPlan$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSceneResponse updateScene(UpdateSceneRequest updateSceneRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSceneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, updateSceneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            UpdateSceneResponse updateSceneResponse = (UpdateSceneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScene").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateSceneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSceneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSceneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$updateScene$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkspaceResponse updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkspaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTTwinMakerClient.resolveMetricPublishers(this.clientConfiguration, updateWorkspaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";
            UpdateWorkspaceResponse updateWorkspaceResponse = (UpdateWorkspaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkspace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateWorkspaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkspaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkspaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTTwinMakerClient.lambda$updateWorkspace$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IoTTwinMakerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConnectorFailureException").exceptionBuilderSupplier(ConnectorFailureException::builder).httpStatusCode(Integer.valueOf(424)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConnectorTimeoutException").exceptionBuilderSupplier(ConnectorTimeoutException::builder).httpStatusCode(Integer.valueOf(424)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryTimeoutException").exceptionBuilderSupplier(QueryTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends IoTTwinMakerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.18.38").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IoTTwinMakerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateWorkspace$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateScene$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePricingPlan$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEntity$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateComponentType$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkspaces$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSyncResources$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSyncJobs$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listScenes$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntities$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listComponentTypes$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkspace$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSyncJob$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getScene$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPropertyValueHistory$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPropertyValue$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPricingPlan$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEntity$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getComponentType$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeQuery$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkspace$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSyncJob$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScene$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEntity$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteComponentType$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkspace$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSyncJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScene$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEntity$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createComponentType$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchPutPropertyValues$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

