/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyValue;
import software.amazon.awssdk.services.iottwinmaker.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyValueHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyValueHistory> {
    private static final SdkField<EntityPropertyReference> ENTITY_PROPERTY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entityPropertyReference").getter(PropertyValueHistory.getter(PropertyValueHistory::entityPropertyReference)).setter(PropertyValueHistory.setter(Builder::entityPropertyReference)).constructor(EntityPropertyReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityPropertyReference").build()}).build();
    private static final SdkField<List<PropertyValue>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(PropertyValueHistory.getter(PropertyValueHistory::values)).setter(PropertyValueHistory.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_PROPERTY_REFERENCE_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final EntityPropertyReference entityPropertyReference;
    private final List<PropertyValue> values;

    private PropertyValueHistory(BuilderImpl builder) {
        this.entityPropertyReference = builder.entityPropertyReference;
        this.values = builder.values;
    }

    public final EntityPropertyReference entityPropertyReference() {
        return this.entityPropertyReference;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<PropertyValue> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityPropertyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValueHistory)) {
            return false;
        }
        PropertyValueHistory other = (PropertyValueHistory)obj;
        return Objects.equals(this.entityPropertyReference(), other.entityPropertyReference()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyValueHistory").add("EntityPropertyReference", (Object)this.entityPropertyReference()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityPropertyReference": {
                return Optional.ofNullable(clazz.cast(this.entityPropertyReference()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyValueHistory, T> g) {
        return obj -> g.apply((PropertyValueHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EntityPropertyReference entityPropertyReference;
        private List<PropertyValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValueHistory model) {
            this.entityPropertyReference(model.entityPropertyReference);
            this.values(model.values);
        }

        public final EntityPropertyReference.Builder getEntityPropertyReference() {
            return this.entityPropertyReference != null ? this.entityPropertyReference.toBuilder() : null;
        }

        public final void setEntityPropertyReference(EntityPropertyReference.BuilderImpl entityPropertyReference) {
            this.entityPropertyReference = entityPropertyReference != null ? entityPropertyReference.build() : null;
        }

        @Override
        @Transient
        public final Builder entityPropertyReference(EntityPropertyReference entityPropertyReference) {
            this.entityPropertyReference = entityPropertyReference;
            return this;
        }

        public final List<PropertyValue.Builder> getValues() {
            List<PropertyValue.Builder> result = ValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<PropertyValue.BuilderImpl> values) {
            this.values = ValuesCopier.copyFromBuilder(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<PropertyValue> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(PropertyValue ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(Consumer<PropertyValue.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (PropertyValue)((PropertyValue.Builder)PropertyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PropertyValueHistory build() {
            return new PropertyValueHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyValueHistory> {
        public Builder entityPropertyReference(EntityPropertyReference var1);

        default public Builder entityPropertyReference(Consumer<EntityPropertyReference.Builder> entityPropertyReference) {
            return this.entityPropertyReference((EntityPropertyReference)((EntityPropertyReference.Builder)EntityPropertyReference.builder().applyMutation(entityPropertyReference)).build());
        }

        public Builder values(Collection<PropertyValue> var1);

        public Builder values(PropertyValue ... var1);

        public Builder values(Consumer<PropertyValue.Builder> ... var1);
    }
}

