/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;

public class SearchEntitiesIterable
implements SdkIterable<SearchEntitiesResponse> {
    private final IoTThingsGraphClient client;
    private final SearchEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchEntitiesIterable(IoTThingsGraphClient client, SearchEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchEntitiesResponseFetcher();
    }

    public Iterator<SearchEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EntityDescription> descriptions() {
        Function<SearchEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.descriptions() != null) {
                return response.descriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchEntitiesResponseFetcher
    implements SyncPageFetcher<SearchEntitiesResponse> {
        private SearchEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(SearchEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchEntitiesResponse nextPage(SearchEntitiesResponse previousPage) {
            if (previousPage == null) {
                return SearchEntitiesIterable.this.client.searchEntities(SearchEntitiesIterable.this.firstRequest);
            }
            return SearchEntitiesIterable.this.client.searchEntities((SearchEntitiesRequest)((Object)SearchEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

