/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadEntityDefinitionsRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<UploadEntityDefinitionsRequest.Builder, UploadEntityDefinitionsRequest> {
    private static final SdkField<DefinitionDocument> DOCUMENT_FIELD = SdkField
            .<DefinitionDocument> builder(MarshallingType.SDK_POJO).getter(getter(UploadEntityDefinitionsRequest::document))
            .setter(setter(Builder::document)).constructor(DefinitionDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<Boolean> SYNC_WITH_PUBLIC_NAMESPACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UploadEntityDefinitionsRequest::syncWithPublicNamespace))
            .setter(setter(Builder::syncWithPublicNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncWithPublicNamespace").build())
            .build();

    private static final SdkField<Boolean> DEPRECATE_EXISTING_ENTITIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(UploadEntityDefinitionsRequest::deprecateExistingEntities))
            .setter(setter(Builder::deprecateExistingEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecateExistingEntities").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD,
            SYNC_WITH_PUBLIC_NAMESPACE_FIELD, DEPRECATE_EXISTING_ENTITIES_FIELD));

    private final DefinitionDocument document;

    private final Boolean syncWithPublicNamespace;

    private final Boolean deprecateExistingEntities;

    private UploadEntityDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
        this.syncWithPublicNamespace = builder.syncWithPublicNamespace;
        this.deprecateExistingEntities = builder.deprecateExistingEntities;
    }

    /**
     * <p>
     * The <code>DefinitionDocument</code> that defines the updated entities.
     * </p>
     * 
     * @return The <code>DefinitionDocument</code> that defines the updated entities.
     */
    public DefinitionDocument document() {
        return document;
    }

    /**
     * <p>
     * A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to
     * <code>true</code>, the upload will create a new namespace version.
     * </p>
     * 
     * @return A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set
     *         to <code>true</code>, the upload will create a new namespace version.
     */
    public Boolean syncWithPublicNamespace() {
        return syncWithPublicNamespace;
    }

    /**
     * <p>
     * A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new
     * <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.
     * </p>
     * 
     * @return A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new
     *         <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace
     *         version.
     */
    public Boolean deprecateExistingEntities() {
        return deprecateExistingEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(syncWithPublicNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(deprecateExistingEntities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadEntityDefinitionsRequest)) {
            return false;
        }
        UploadEntityDefinitionsRequest other = (UploadEntityDefinitionsRequest) obj;
        return Objects.equals(document(), other.document())
                && Objects.equals(syncWithPublicNamespace(), other.syncWithPublicNamespace())
                && Objects.equals(deprecateExistingEntities(), other.deprecateExistingEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UploadEntityDefinitionsRequest").add("Document", document())
                .add("SyncWithPublicNamespace", syncWithPublicNamespace())
                .add("DeprecateExistingEntities", deprecateExistingEntities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "syncWithPublicNamespace":
            return Optional.ofNullable(clazz.cast(syncWithPublicNamespace()));
        case "deprecateExistingEntities":
            return Optional.ofNullable(clazz.cast(deprecateExistingEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadEntityDefinitionsRequest, T> g) {
        return obj -> g.apply((UploadEntityDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UploadEntityDefinitionsRequest> {
        /**
         * <p>
         * The <code>DefinitionDocument</code> that defines the updated entities.
         * </p>
         * 
         * @param document
         *        The <code>DefinitionDocument</code> that defines the updated entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DefinitionDocument document);

        /**
         * <p>
         * The <code>DefinitionDocument</code> that defines the updated entities.
         * </p>
         * This is a convenience that creates an instance of the {@link DefinitionDocument.Builder} avoiding the need to
         * create one manually via {@link DefinitionDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefinitionDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #document(DefinitionDocument)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DefinitionDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DefinitionDocument)
         */
        default Builder document(Consumer<DefinitionDocument.Builder> document) {
            return document(DefinitionDocument.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * A Boolean that specifies whether to synchronize with the latest version of the public namespace. If set to
         * <code>true</code>, the upload will create a new namespace version.
         * </p>
         * 
         * @param syncWithPublicNamespace
         *        A Boolean that specifies whether to synchronize with the latest version of the public namespace. If
         *        set to <code>true</code>, the upload will create a new namespace version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncWithPublicNamespace(Boolean syncWithPublicNamespace);

        /**
         * <p>
         * A Boolean that specifies whether to deprecate all entities in the latest version before uploading the new
         * <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new namespace version.
         * </p>
         * 
         * @param deprecateExistingEntities
         *        A Boolean that specifies whether to deprecate all entities in the latest version before uploading the
         *        new <code>DefinitionDocument</code>. If set to <code>true</code>, the upload will create a new
         *        namespace version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecateExistingEntities(Boolean deprecateExistingEntities);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private DefinitionDocument document;

        private Boolean syncWithPublicNamespace;

        private Boolean deprecateExistingEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadEntityDefinitionsRequest model) {
            super(model);
            document(model.document);
            syncWithPublicNamespace(model.syncWithPublicNamespace);
            deprecateExistingEntities(model.deprecateExistingEntities);
        }

        public final DefinitionDocument.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        @Override
        public final Builder document(DefinitionDocument document) {
            this.document = document;
            return this;
        }

        public final void setDocument(DefinitionDocument.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        public final Boolean getSyncWithPublicNamespace() {
            return syncWithPublicNamespace;
        }

        @Override
        public final Builder syncWithPublicNamespace(Boolean syncWithPublicNamespace) {
            this.syncWithPublicNamespace = syncWithPublicNamespace;
            return this;
        }

        public final void setSyncWithPublicNamespace(Boolean syncWithPublicNamespace) {
            this.syncWithPublicNamespace = syncWithPublicNamespace;
        }

        public final Boolean getDeprecateExistingEntities() {
            return deprecateExistingEntities;
        }

        @Override
        public final Builder deprecateExistingEntities(Boolean deprecateExistingEntities) {
            this.deprecateExistingEntities = deprecateExistingEntities;
            return this;
        }

        public final void setDeprecateExistingEntities(Boolean deprecateExistingEntities) {
            this.deprecateExistingEntities = deprecateExistingEntities;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadEntityDefinitionsRequest build() {
            return new UploadEntityDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
