/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.InternalFailureException;
import software.amazon.awssdk.services.iotthingsgraph.model.InvalidRequestException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.LimitExceededException;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceInUseException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ThrottlingException;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable;
import software.amazon.awssdk.services.iotthingsgraph.transform.AssociateEntityToThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DissociateEntityFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetNamespaceDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetUploadStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListFlowExecutionMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemInstancesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchThingsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UndeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UploadEntityDefinitionsRequestMarshaller;

@SdkInternalApi
final class DefaultIoTThingsGraphClient
implements IoTThingsGraphClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTThingsGraphClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iotthingsgraph";
    }

    @Override
    public AssociateEntityToThingResponse associateEntityToThing(AssociateEntityToThingRequest associateEntityToThingRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateEntityToThingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateEntityToThingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateEntityToThing").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateEntityToThingRequest).withMarshaller((Marshaller)new AssociateEntityToThingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateFlowTemplateResponse createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFlowTemplateRequest).withMarshaller((Marshaller)new CreateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateSystemInstanceResponse createSystemInstance(CreateSystemInstanceRequest createSystemInstanceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateSystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSystemInstanceRequest).withMarshaller((Marshaller)new CreateSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateSystemTemplateResponse createSystemTemplate(CreateSystemTemplateRequest createSystemTemplateRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSystemTemplateRequest).withMarshaller((Marshaller)new CreateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFlowTemplateResponse deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFlowTemplateRequest).withMarshaller((Marshaller)new DeleteFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamespaceRequest).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSystemInstanceResponse deleteSystemInstance(DeleteSystemInstanceRequest deleteSystemInstanceRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSystemInstanceRequest).withMarshaller((Marshaller)new DeleteSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteSystemTemplateResponse deleteSystemTemplate(DeleteSystemTemplateRequest deleteSystemTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSystemTemplateRequest).withMarshaller((Marshaller)new DeleteSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeploySystemInstanceResponse deploySystemInstance(DeploySystemInstanceRequest deploySystemInstanceRequest) throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeploySystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeploySystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeploySystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deploySystemInstanceRequest).withMarshaller((Marshaller)new DeploySystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeprecateFlowTemplateResponse deprecateFlowTemplate(DeprecateFlowTemplateRequest deprecateFlowTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeprecateFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateFlowTemplateRequest).withMarshaller((Marshaller)new DeprecateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeprecateSystemTemplateResponse deprecateSystemTemplate(DeprecateSystemTemplateRequest deprecateSystemTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeprecateSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateSystemTemplateRequest).withMarshaller((Marshaller)new DeprecateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest describeNamespaceRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNamespaceRequest).withMarshaller((Marshaller)new DescribeNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DissociateEntityFromThingResponse dissociateEntityFromThing(DissociateEntityFromThingRequest dissociateEntityFromThingRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DissociateEntityFromThingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DissociateEntityFromThingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DissociateEntityFromThing").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)dissociateEntityFromThingRequest).withMarshaller((Marshaller)new DissociateEntityFromThingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetEntitiesResponse getEntities(GetEntitiesRequest getEntitiesRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEntitiesRequest).withMarshaller((Marshaller)new GetEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFlowTemplateResponse getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFlowTemplateRequest).withMarshaller((Marshaller)new GetFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFlowTemplateRevisionsResponse getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFlowTemplateRevisionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFlowTemplateRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFlowTemplateRevisions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFlowTemplateRevisionsRequest).withMarshaller((Marshaller)new GetFlowTemplateRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFlowTemplateRevisionsIterable getFlowTemplateRevisionsPaginator(GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new GetFlowTemplateRevisionsIterable(this, this.applyPaginatorUserAgent(getFlowTemplateRevisionsRequest));
    }

    @Override
    public GetNamespaceDeletionStatusResponse getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamespaceDeletionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetNamespaceDeletionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamespaceDeletionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamespaceDeletionStatusRequest).withMarshaller((Marshaller)new GetNamespaceDeletionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSystemInstanceResponse getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSystemInstanceRequest).withMarshaller((Marshaller)new GetSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSystemTemplateResponse getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSystemTemplateRequest).withMarshaller((Marshaller)new GetSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSystemTemplateRevisionsResponse getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemTemplateRevisionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSystemTemplateRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemTemplateRevisions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSystemTemplateRevisionsRequest).withMarshaller((Marshaller)new GetSystemTemplateRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSystemTemplateRevisionsIterable getSystemTemplateRevisionsPaginator(GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new GetSystemTemplateRevisionsIterable(this, this.applyPaginatorUserAgent(getSystemTemplateRevisionsRequest));
    }

    @Override
    public GetUploadStatusResponse getUploadStatus(GetUploadStatusRequest getUploadStatusRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUploadStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetUploadStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUploadStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUploadStatusRequest).withMarshaller((Marshaller)new GetUploadStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListFlowExecutionMessagesResponse listFlowExecutionMessages(ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowExecutionMessagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListFlowExecutionMessagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlowExecutionMessages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFlowExecutionMessagesRequest).withMarshaller((Marshaller)new ListFlowExecutionMessagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListFlowExecutionMessagesIterable listFlowExecutionMessagesPaginator(ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new ListFlowExecutionMessagesIterable(this, this.applyPaginatorUserAgent(listFlowExecutionMessagesRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public SearchEntitiesResponse searchEntities(SearchEntitiesRequest searchEntitiesRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchEntitiesRequest).withMarshaller((Marshaller)new SearchEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchEntitiesIterable searchEntitiesPaginator(SearchEntitiesRequest searchEntitiesRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchEntitiesIterable(this, this.applyPaginatorUserAgent(searchEntitiesRequest));
    }

    @Override
    public SearchFlowExecutionsResponse searchFlowExecutions(SearchFlowExecutionsRequest searchFlowExecutionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFlowExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchFlowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFlowExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFlowExecutionsRequest).withMarshaller((Marshaller)new SearchFlowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchFlowExecutionsIterable searchFlowExecutionsPaginator(SearchFlowExecutionsRequest searchFlowExecutionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchFlowExecutionsIterable(this, this.applyPaginatorUserAgent(searchFlowExecutionsRequest));
    }

    @Override
    public SearchFlowTemplatesResponse searchFlowTemplates(SearchFlowTemplatesRequest searchFlowTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFlowTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchFlowTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFlowTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFlowTemplatesRequest).withMarshaller((Marshaller)new SearchFlowTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchFlowTemplatesIterable searchFlowTemplatesPaginator(SearchFlowTemplatesRequest searchFlowTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchFlowTemplatesIterable(this, this.applyPaginatorUserAgent(searchFlowTemplatesRequest));
    }

    @Override
    public SearchSystemInstancesResponse searchSystemInstances(SearchSystemInstancesRequest searchSystemInstancesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSystemInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchSystemInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSystemInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchSystemInstancesRequest).withMarshaller((Marshaller)new SearchSystemInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchSystemInstancesIterable searchSystemInstancesPaginator(SearchSystemInstancesRequest searchSystemInstancesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchSystemInstancesIterable(this, this.applyPaginatorUserAgent(searchSystemInstancesRequest));
    }

    @Override
    public SearchSystemTemplatesResponse searchSystemTemplates(SearchSystemTemplatesRequest searchSystemTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSystemTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchSystemTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSystemTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchSystemTemplatesRequest).withMarshaller((Marshaller)new SearchSystemTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchSystemTemplatesIterable searchSystemTemplatesPaginator(SearchSystemTemplatesRequest searchSystemTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchSystemTemplatesIterable(this, this.applyPaginatorUserAgent(searchSystemTemplatesRequest));
    }

    @Override
    public SearchThingsResponse searchThings(SearchThingsRequest searchThingsRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchThingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SearchThingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchThings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchThingsRequest).withMarshaller((Marshaller)new SearchThingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SearchThingsIterable searchThingsPaginator(SearchThingsRequest searchThingsRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchThingsIterable(this, this.applyPaginatorUserAgent(searchThingsRequest));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UndeploySystemInstanceResponse undeploySystemInstance(UndeploySystemInstanceRequest undeploySystemInstanceRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeploySystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UndeploySystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeploySystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)undeploySystemInstanceRequest).withMarshaller((Marshaller)new UndeploySystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateFlowTemplateResponse updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFlowTemplateRequest).withMarshaller((Marshaller)new UpdateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateSystemTemplateResponse updateSystemTemplate(UpdateSystemTemplateRequest updateSystemTemplateRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSystemTemplateRequest).withMarshaller((Marshaller)new UpdateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UploadEntityDefinitionsResponse uploadEntityDefinitions(UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadEntityDefinitionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UploadEntityDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadEntityDefinitions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)uploadEntityDefinitionsRequest).withMarshaller((Marshaller)new UploadEntityDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IoTThingsGraphException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends IoTThingsGraphRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.26").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IoTThingsGraphRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

