/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowExecutionMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowExecutionMessage> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowExecutionMessage.getter(FlowExecutionMessage::messageId)).setter(FlowExecutionMessage.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowExecutionMessage.getter(FlowExecutionMessage::eventTypeAsString)).setter(FlowExecutionMessage.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FlowExecutionMessage.getter(FlowExecutionMessage::timestamp)).setter(FlowExecutionMessage.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FlowExecutionMessage.getter(FlowExecutionMessage::payload)).setter(FlowExecutionMessage.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, EVENT_TYPE_FIELD, TIMESTAMP_FIELD, PAYLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String eventType;
    private final Instant timestamp;
    private final String payload;

    private FlowExecutionMessage(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
        this.payload = builder.payload;
    }

    public String messageId() {
        return this.messageId;
    }

    public FlowExecutionEventType eventType() {
        return FlowExecutionEventType.fromValue(this.eventType);
    }

    public String eventTypeAsString() {
        return this.eventType;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionMessage)) {
            return false;
        }
        FlowExecutionMessage other = (FlowExecutionMessage)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        return ToString.builder((String)"FlowExecutionMessage").add("MessageId", (Object)this.messageId()).add("EventType", (Object)this.eventTypeAsString()).add("Timestamp", (Object)this.timestamp()).add("Payload", (Object)this.payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionMessage, T> g) {
        return obj -> g.apply((FlowExecutionMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String eventType;
        private Instant timestamp;
        private String payload;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionMessage model) {
            this.messageId(model.messageId);
            this.eventType(model.eventType);
            this.timestamp(model.timestamp);
            this.payload(model.payload);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(FlowExecutionEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        public FlowExecutionMessage build() {
            return new FlowExecutionMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowExecutionMessage> {
        public Builder messageId(String var1);

        public Builder eventType(String var1);

        public Builder eventType(FlowExecutionEventType var1);

        public Builder timestamp(Instant var1);

        public Builder payload(String var1);
    }
}

