/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an asset property value (of a single type only).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Variant implements SdkPojo, Serializable, ToCopyableBuilder<Variant.Builder, Variant> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(Variant::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("integerValue").getter(getter(Variant::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(Variant::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("booleanValue").getter(getter(Variant::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<PropertyValueNullValue> NULL_VALUE_FIELD = SdkField
            .<PropertyValueNullValue> builder(MarshallingType.SDK_POJO).memberName("nullValue")
            .getter(getter(Variant::nullValue)).setter(setter(Builder::nullValue)).constructor(PropertyValueNullValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nullValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD, NULL_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Integer integerValue;

    private final Double doubleValue;

    private final Boolean booleanValue;

    private final PropertyValueNullValue nullValue;

    private Variant(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
        this.nullValue = builder.nullValue;
    }

    /**
     * <p>
     * Asset property data of type string (sequence of characters). The allowed pattern: "^$|[^\u0000-\u001F\u007F]+".
     * The max length is 1024.
     * </p>
     * 
     * @return Asset property data of type string (sequence of characters). The allowed pattern:
     *         "^$|[^\u0000-\u001F\u007F]+". The max length is 1024.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * Asset property data of type integer (whole number).
     * </p>
     * 
     * @return Asset property data of type integer (whole number).
     */
    public final Integer integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * Asset property data of type double (floating point number). The min value is -10^10. The max value is 10^10.
     * Double.NaN is allowed.
     * </p>
     * 
     * @return Asset property data of type double (floating point number). The min value is -10^10. The max value is
     *         10^10. Double.NaN is allowed.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * Asset property data of type Boolean (true or false).
     * </p>
     * 
     * @return Asset property data of type Boolean (true or false).
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * The type of null asset property data with BAD and UNCERTAIN qualities.
     * </p>
     * 
     * @return The type of null asset property data with BAD and UNCERTAIN qualities.
     */
    public final PropertyValueNullValue nullValue() {
        return nullValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(nullValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant other = (Variant) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(integerValue(), other.integerValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(nullValue(), other.nullValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Variant").add("StringValue", stringValue()).add("IntegerValue", integerValue())
                .add("DoubleValue", doubleValue()).add("BooleanValue", booleanValue()).add("NullValue", nullValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "integerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "nullValue":
            return Optional.ofNullable(clazz.cast(nullValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("integerValue", INTEGER_VALUE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("booleanValue", BOOLEAN_VALUE_FIELD);
        map.put("nullValue", NULL_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Variant, T> g) {
        return obj -> g.apply((Variant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Variant> {
        /**
         * <p>
         * Asset property data of type string (sequence of characters). The allowed pattern:
         * "^$|[^\u0000-\u001F\u007F]+". The max length is 1024.
         * </p>
         * 
         * @param stringValue
         *        Asset property data of type string (sequence of characters). The allowed pattern:
         *        "^$|[^\u0000-\u001F\u007F]+". The max length is 1024.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * Asset property data of type integer (whole number).
         * </p>
         * 
         * @param integerValue
         *        Asset property data of type integer (whole number).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * <p>
         * Asset property data of type double (floating point number). The min value is -10^10. The max value is 10^10.
         * Double.NaN is allowed.
         * </p>
         * 
         * @param doubleValue
         *        Asset property data of type double (floating point number). The min value is -10^10. The max value is
         *        10^10. Double.NaN is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * Asset property data of type Boolean (true or false).
         * </p>
         * 
         * @param booleanValue
         *        Asset property data of type Boolean (true or false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * The type of null asset property data with BAD and UNCERTAIN qualities.
         * </p>
         * 
         * @param nullValue
         *        The type of null asset property data with BAD and UNCERTAIN qualities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullValue(PropertyValueNullValue nullValue);

        /**
         * <p>
         * The type of null asset property data with BAD and UNCERTAIN qualities.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyValueNullValue.Builder} avoiding
         * the need to create one manually via {@link PropertyValueNullValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyValueNullValue.Builder#build()} is called immediately and
         * its result is passed to {@link #nullValue(PropertyValueNullValue)}.
         * 
         * @param nullValue
         *        a consumer that will call methods on {@link PropertyValueNullValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nullValue(PropertyValueNullValue)
         */
        default Builder nullValue(Consumer<PropertyValueNullValue.Builder> nullValue) {
            return nullValue(PropertyValueNullValue.builder().applyMutation(nullValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Integer integerValue;

        private Double doubleValue;

        private Boolean booleanValue;

        private PropertyValueNullValue nullValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Variant model) {
            stringValue(model.stringValue);
            integerValue(model.integerValue);
            doubleValue(model.doubleValue);
            booleanValue(model.booleanValue);
            nullValue(model.nullValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final PropertyValueNullValue.Builder getNullValue() {
            return nullValue != null ? nullValue.toBuilder() : null;
        }

        public final void setNullValue(PropertyValueNullValue.BuilderImpl nullValue) {
            this.nullValue = nullValue != null ? nullValue.build() : null;
        }

        @Override
        public final Builder nullValue(PropertyValueNullValue nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public Variant build() {
            return new Variant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
