/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComputationModelRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateComputationModelRequest.Builder, UpdateComputationModelRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelId").getter(getter(UpdateComputationModelRequest::computationModelId))
            .setter(setter(Builder::computationModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("computationModelId").build()).build();

    private static final SdkField<String> COMPUTATION_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelName").getter(getter(UpdateComputationModelRequest::computationModelName))
            .setter(setter(Builder::computationModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelName").build())
            .build();

    private static final SdkField<String> COMPUTATION_MODEL_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("computationModelDescription")
            .getter(getter(UpdateComputationModelRequest::computationModelDescription))
            .setter(setter(Builder::computationModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDescription")
                    .build()).build();

    private static final SdkField<ComputationModelConfiguration> COMPUTATION_MODEL_CONFIGURATION_FIELD = SdkField
            .<ComputationModelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("computationModelConfiguration")
            .getter(getter(UpdateComputationModelRequest::computationModelConfiguration))
            .setter(setter(Builder::computationModelConfiguration))
            .constructor(ComputationModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, ComputationModelDataBindingValue>> COMPUTATION_MODEL_DATA_BINDING_FIELD = SdkField
            .<Map<String, ComputationModelDataBindingValue>> builder(MarshallingType.MAP)
            .memberName("computationModelDataBinding")
            .getter(getter(UpdateComputationModelRequest::computationModelDataBinding))
            .setter(setter(Builder::computationModelDataBinding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDataBinding")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComputationModelDataBindingValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputationModelDataBindingValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateComputationModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD,
            COMPUTATION_MODEL_NAME_FIELD, COMPUTATION_MODEL_DESCRIPTION_FIELD, COMPUTATION_MODEL_CONFIGURATION_FIELD,
            COMPUTATION_MODEL_DATA_BINDING_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computationModelId;

    private final String computationModelName;

    private final String computationModelDescription;

    private final ComputationModelConfiguration computationModelConfiguration;

    private final Map<String, ComputationModelDataBindingValue> computationModelDataBinding;

    private final String clientToken;

    private UpdateComputationModelRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelName = builder.computationModelName;
        this.computationModelDescription = builder.computationModelDescription;
        this.computationModelConfiguration = builder.computationModelConfiguration;
        this.computationModelDataBinding = builder.computationModelDataBinding;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the computation model.
     * </p>
     * 
     * @return The ID of the computation model.
     */
    public final String computationModelId() {
        return computationModelId;
    }

    /**
     * <p>
     * The name of the computation model.
     * </p>
     * 
     * @return The name of the computation model.
     */
    public final String computationModelName() {
        return computationModelName;
    }

    /**
     * <p>
     * The description of the computation model.
     * </p>
     * 
     * @return The description of the computation model.
     */
    public final String computationModelDescription() {
        return computationModelDescription;
    }

    /**
     * <p>
     * The configuration for the computation model.
     * </p>
     * 
     * @return The configuration for the computation model.
     */
    public final ComputationModelConfiguration computationModelConfiguration() {
        return computationModelConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputationModelDataBinding property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputationModelDataBinding() {
        return computationModelDataBinding != null && !(computationModelDataBinding instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The data binding for the computation model. Key is a variable name defined in configuration. Value is a
     * <code>ComputationModelDataBindingValue</code> referenced by the variable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputationModelDataBinding} method.
     * </p>
     * 
     * @return The data binding for the computation model. Key is a variable name defined in configuration. Value is a
     *         <code>ComputationModelDataBindingValue</code> referenced by the variable.
     */
    public final Map<String, ComputationModelDataBindingValue> computationModelDataBinding() {
        return computationModelDataBinding;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelName());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(computationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputationModelDataBinding() ? computationModelDataBinding() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputationModelRequest)) {
            return false;
        }
        UpdateComputationModelRequest other = (UpdateComputationModelRequest) obj;
        return Objects.equals(computationModelId(), other.computationModelId())
                && Objects.equals(computationModelName(), other.computationModelName())
                && Objects.equals(computationModelDescription(), other.computationModelDescription())
                && Objects.equals(computationModelConfiguration(), other.computationModelConfiguration())
                && hasComputationModelDataBinding() == other.hasComputationModelDataBinding()
                && Objects.equals(computationModelDataBinding(), other.computationModelDataBinding())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComputationModelRequest").add("ComputationModelId", computationModelId())
                .add("ComputationModelName", computationModelName())
                .add("ComputationModelDescription", computationModelDescription())
                .add("ComputationModelConfiguration", computationModelConfiguration())
                .add("ComputationModelDataBinding", hasComputationModelDataBinding() ? computationModelDataBinding() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelId":
            return Optional.ofNullable(clazz.cast(computationModelId()));
        case "computationModelName":
            return Optional.ofNullable(clazz.cast(computationModelName()));
        case "computationModelDescription":
            return Optional.ofNullable(clazz.cast(computationModelDescription()));
        case "computationModelConfiguration":
            return Optional.ofNullable(clazz.cast(computationModelConfiguration()));
        case "computationModelDataBinding":
            return Optional.ofNullable(clazz.cast(computationModelDataBinding()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelName", COMPUTATION_MODEL_NAME_FIELD);
        map.put("computationModelDescription", COMPUTATION_MODEL_DESCRIPTION_FIELD);
        map.put("computationModelConfiguration", COMPUTATION_MODEL_CONFIGURATION_FIELD);
        map.put("computationModelDataBinding", COMPUTATION_MODEL_DATA_BINDING_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputationModelRequest, T> g) {
        return obj -> g.apply((UpdateComputationModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComputationModelRequest> {
        /**
         * <p>
         * The ID of the computation model.
         * </p>
         * 
         * @param computationModelId
         *        The ID of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelId(String computationModelId);

        /**
         * <p>
         * The name of the computation model.
         * </p>
         * 
         * @param computationModelName
         *        The name of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelName(String computationModelName);

        /**
         * <p>
         * The description of the computation model.
         * </p>
         * 
         * @param computationModelDescription
         *        The description of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelDescription(String computationModelDescription);

        /**
         * <p>
         * The configuration for the computation model.
         * </p>
         * 
         * @param computationModelConfiguration
         *        The configuration for the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration);

        /**
         * <p>
         * The configuration for the computation model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationModelConfiguration.Builder}
         * avoiding the need to create one manually via {@link ComputationModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationModelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #computationModelConfiguration(ComputationModelConfiguration)}.
         * 
         * @param computationModelConfiguration
         *        a consumer that will call methods on {@link ComputationModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationModelConfiguration(ComputationModelConfiguration)
         */
        default Builder computationModelConfiguration(
                Consumer<ComputationModelConfiguration.Builder> computationModelConfiguration) {
            return computationModelConfiguration(ComputationModelConfiguration.builder()
                    .applyMutation(computationModelConfiguration).build());
        }

        /**
         * <p>
         * The data binding for the computation model. Key is a variable name defined in configuration. Value is a
         * <code>ComputationModelDataBindingValue</code> referenced by the variable.
         * </p>
         * 
         * @param computationModelDataBinding
         *        The data binding for the computation model. Key is a variable name defined in configuration. Value is
         *        a <code>ComputationModelDataBindingValue</code> referenced by the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String computationModelId;

        private String computationModelName;

        private String computationModelDescription;

        private ComputationModelConfiguration computationModelConfiguration;

        private Map<String, ComputationModelDataBindingValue> computationModelDataBinding = DefaultSdkAutoConstructMap
                .getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputationModelRequest model) {
            super(model);
            computationModelId(model.computationModelId);
            computationModelName(model.computationModelName);
            computationModelDescription(model.computationModelDescription);
            computationModelConfiguration(model.computationModelConfiguration);
            computationModelDataBinding(model.computationModelDataBinding);
            clientToken(model.clientToken);
        }

        public final String getComputationModelId() {
            return computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelName() {
            return computationModelName;
        }

        public final void setComputationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
        }

        @Override
        public final Builder computationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
            return this;
        }

        public final String getComputationModelDescription() {
            return computationModelDescription;
        }

        public final void setComputationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
        }

        @Override
        public final Builder computationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
            return this;
        }

        public final ComputationModelConfiguration.Builder getComputationModelConfiguration() {
            return computationModelConfiguration != null ? computationModelConfiguration.toBuilder() : null;
        }

        public final void setComputationModelConfiguration(ComputationModelConfiguration.BuilderImpl computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration != null ? computationModelConfiguration.build()
                    : null;
        }

        @Override
        public final Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        public final Map<String, ComputationModelDataBindingValue.Builder> getComputationModelDataBinding() {
            Map<String, ComputationModelDataBindingValue.Builder> result = ComputationModelDataBindingCopier
                    .copyToBuilder(this.computationModelDataBinding);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputationModelDataBinding(
                Map<String, ComputationModelDataBindingValue.BuilderImpl> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copyFromBuilder(computationModelDataBinding);
        }

        @Override
        public final Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copy(computationModelDataBinding);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputationModelRequest build() {
            return new UpdateComputationModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
