/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the reference information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Reference implements SdkPojo, Serializable, ToCopyableBuilder<Reference.Builder, Reference> {
    private static final SdkField<DataSetReference> DATASET_FIELD = SdkField.<DataSetReference> builder(MarshallingType.SDK_POJO)
            .memberName("dataset").getter(getter(Reference::dataset)).setter(setter(Builder::dataset))
            .constructor(DataSetReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataSetReference dataset;

    private Reference(BuilderImpl builder) {
        this.dataset = builder.dataset;
    }

    /**
     * <p>
     * Contains the dataset reference information.
     * </p>
     * 
     * @return Contains the dataset reference information.
     */
    public final DataSetReference dataset() {
        return dataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference) obj;
        return Objects.equals(dataset(), other.dataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Reference").add("Dataset", dataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataset", DATASET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Reference, T> g) {
        return obj -> g.apply((Reference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Reference> {
        /**
         * <p>
         * Contains the dataset reference information.
         * </p>
         * 
         * @param dataset
         *        Contains the dataset reference information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(DataSetReference dataset);

        /**
         * <p>
         * Contains the dataset reference information.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetReference.Builder} avoiding the
         * need to create one manually via {@link DataSetReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetReference.Builder#build()} is called immediately and its
         * result is passed to {@link #dataset(DataSetReference)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link DataSetReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(DataSetReference)
         */
        default Builder dataset(Consumer<DataSetReference.Builder> dataset) {
            return dataset(DataSetReference.builder().applyMutation(dataset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataSetReference dataset;

        private BuilderImpl() {
        }

        private BuilderImpl(Reference model) {
            dataset(model.dataset);
        }

        public final DataSetReference.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        public final void setDataset(DataSetReference.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(DataSetReference dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public Reference build() {
            return new Reference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
