/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration options for mapping properties from an interface asset model to an asset model where the
 * interface is applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyMappingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyMappingConfiguration.Builder, PropertyMappingConfiguration> {
    private static final SdkField<Boolean> MATCH_BY_PROPERTY_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("matchByPropertyName").getter(getter(PropertyMappingConfiguration::matchByPropertyName))
            .setter(setter(Builder::matchByPropertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchByPropertyName").build())
            .build();

    private static final SdkField<Boolean> CREATE_MISSING_PROPERTY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createMissingProperty").getter(getter(PropertyMappingConfiguration::createMissingProperty))
            .setter(setter(Builder::createMissingProperty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createMissingProperty").build())
            .build();

    private static final SdkField<List<PropertyMapping>> OVERRIDES_FIELD = SdkField
            .<List<PropertyMapping>> builder(MarshallingType.LIST)
            .memberName("overrides")
            .getter(getter(PropertyMappingConfiguration::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_BY_PROPERTY_NAME_FIELD,
            CREATE_MISSING_PROPERTY_FIELD, OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean matchByPropertyName;

    private final Boolean createMissingProperty;

    private final List<PropertyMapping> overrides;

    private PropertyMappingConfiguration(BuilderImpl builder) {
        this.matchByPropertyName = builder.matchByPropertyName;
        this.createMissingProperty = builder.createMissingProperty;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * If true, properties are matched by name between the interface asset model and the asset model where the interface
     * is applied.
     * </p>
     * 
     * @return If true, properties are matched by name between the interface asset model and the asset model where the
     *         interface is applied.
     */
    public final Boolean matchByPropertyName() {
        return matchByPropertyName;
    }

    /**
     * <p>
     * If true, missing properties from the interface asset model are automatically created in the asset model where the
     * interface is applied.
     * </p>
     * 
     * @return If true, missing properties from the interface asset model are automatically created in the asset model
     *         where the interface is applied.
     */
    public final Boolean createMissingProperty() {
        return createMissingProperty;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific property mappings that override the automatic mapping by name when an interface is applied to
     * an asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return A list of specific property mappings that override the automatic mapping by name when an interface is
     *         applied to an asset model.
     */
    public final List<PropertyMapping> overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchByPropertyName());
        hashCode = 31 * hashCode + Objects.hashCode(createMissingProperty());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyMappingConfiguration)) {
            return false;
        }
        PropertyMappingConfiguration other = (PropertyMappingConfiguration) obj;
        return Objects.equals(matchByPropertyName(), other.matchByPropertyName())
                && Objects.equals(createMissingProperty(), other.createMissingProperty())
                && hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyMappingConfiguration").add("MatchByPropertyName", matchByPropertyName())
                .add("CreateMissingProperty", createMissingProperty()).add("Overrides", hasOverrides() ? overrides() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "matchByPropertyName":
            return Optional.ofNullable(clazz.cast(matchByPropertyName()));
        case "createMissingProperty":
            return Optional.ofNullable(clazz.cast(createMissingProperty()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("matchByPropertyName", MATCH_BY_PROPERTY_NAME_FIELD);
        map.put("createMissingProperty", CREATE_MISSING_PROPERTY_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyMappingConfiguration, T> g) {
        return obj -> g.apply((PropertyMappingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyMappingConfiguration> {
        /**
         * <p>
         * If true, properties are matched by name between the interface asset model and the asset model where the
         * interface is applied.
         * </p>
         * 
         * @param matchByPropertyName
         *        If true, properties are matched by name between the interface asset model and the asset model where
         *        the interface is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchByPropertyName(Boolean matchByPropertyName);

        /**
         * <p>
         * If true, missing properties from the interface asset model are automatically created in the asset model where
         * the interface is applied.
         * </p>
         * 
         * @param createMissingProperty
         *        If true, missing properties from the interface asset model are automatically created in the asset
         *        model where the interface is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createMissingProperty(Boolean createMissingProperty);

        /**
         * <p>
         * A list of specific property mappings that override the automatic mapping by name when an interface is applied
         * to an asset model.
         * </p>
         * 
         * @param overrides
         *        A list of specific property mappings that override the automatic mapping by name when an interface is
         *        applied to an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<PropertyMapping> overrides);

        /**
         * <p>
         * A list of specific property mappings that override the automatic mapping by name when an interface is applied
         * to an asset model.
         * </p>
         * 
         * @param overrides
         *        A list of specific property mappings that override the automatic mapping by name when an interface is
         *        applied to an asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(PropertyMapping... overrides);

        /**
         * <p>
         * A list of specific property mappings that override the automatic mapping by name when an interface is applied
         * to an asset model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(List<PropertyMapping>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.PropertyMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(java.util.Collection<PropertyMapping>)
         */
        Builder overrides(Consumer<PropertyMapping.Builder>... overrides);
    }

    static final class BuilderImpl implements Builder {
        private Boolean matchByPropertyName;

        private Boolean createMissingProperty;

        private List<PropertyMapping> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyMappingConfiguration model) {
            matchByPropertyName(model.matchByPropertyName);
            createMissingProperty(model.createMissingProperty);
            overrides(model.overrides);
        }

        public final Boolean getMatchByPropertyName() {
            return matchByPropertyName;
        }

        public final void setMatchByPropertyName(Boolean matchByPropertyName) {
            this.matchByPropertyName = matchByPropertyName;
        }

        @Override
        public final Builder matchByPropertyName(Boolean matchByPropertyName) {
            this.matchByPropertyName = matchByPropertyName;
            return this;
        }

        public final Boolean getCreateMissingProperty() {
            return createMissingProperty;
        }

        public final void setCreateMissingProperty(Boolean createMissingProperty) {
            this.createMissingProperty = createMissingProperty;
        }

        @Override
        public final Builder createMissingProperty(Boolean createMissingProperty) {
            this.createMissingProperty = createMissingProperty;
            return this;
        }

        public final List<PropertyMapping.Builder> getOverrides() {
            List<PropertyMapping.Builder> result = PropertyMappingsCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<PropertyMapping.BuilderImpl> overrides) {
            this.overrides = PropertyMappingsCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<PropertyMapping> overrides) {
            this.overrides = PropertyMappingsCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(PropertyMapping... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<PropertyMapping.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> PropertyMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PropertyMappingConfiguration build() {
            return new PropertyMappingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
