/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a portal summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortalSummary implements SdkPojo, Serializable, ToCopyableBuilder<PortalSummary.Builder, PortalSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PortalSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PortalSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PortalSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> START_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startUrl").getter(getter(PortalSummary::startUrl)).setter(setter(Builder::startUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startUrl").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(PortalSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(PortalSummary::lastUpdateDate)).setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(PortalSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<PortalStatus> STATUS_FIELD = SdkField.<PortalStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(PortalSummary::status)).setter(setter(Builder::status))
            .constructor(PortalStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> PORTAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalType").getter(getter(PortalSummary::portalTypeAsString)).setter(setter(Builder::portalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, START_URL_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD,
            PORTAL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String startUrl;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private final String roleArn;

    private final PortalStatus status;

    private final String portalType;

    private PortalSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.startUrl = builder.startUrl;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.portalType = builder.portalType;
    }

    /**
     * <p>
     * The ID of the portal.
     * </p>
     * 
     * @return The ID of the portal.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the portal.
     * </p>
     * 
     * @return The name of the portal.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The portal's description.
     * </p>
     * 
     * @return The portal's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center
     * for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a
     * URL that you can use to access the portal.
     * </p>
     * 
     * @return The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity
     *         Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise
     *         console to get a URL that you can use to access the portal.
     */
    public final String startUrl() {
        return startUrl;
    }

    /**
     * <p>
     * The date the portal was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the portal was created, in Unix epoch time.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the portal was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the portal was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service
     * role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     *         roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the Status property for this object.
     * 
     * @return The value of the Status property for this object.
     */
    public final PortalStatus status() {
        return status;
    }

    /**
     * <p>
     * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>. The
     * value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalType} will
     * return {@link PortalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalTypeAsString}.
     * </p>
     * 
     * @return Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
     *         <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
     *         <code>SITEWISE_PORTAL_V2</code>.
     * @see PortalType
     */
    public final PortalType portalType() {
        return PortalType.fromValue(portalType);
    }

    /**
     * <p>
     * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>. The
     * value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalType} will
     * return {@link PortalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalTypeAsString}.
     * </p>
     * 
     * @return Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
     *         <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
     *         <code>SITEWISE_PORTAL_V2</code>.
     * @see PortalType
     */
    public final String portalTypeAsString() {
        return portalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startUrl());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(portalTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalSummary)) {
            return false;
        }
        PortalSummary other = (PortalSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(startUrl(), other.startUrl())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(status(), other.status()) && Objects.equals(portalTypeAsString(), other.portalTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortalSummary").add("Id", id()).add("Name", name()).add("Description", description())
                .add("StartUrl", startUrl()).add("CreationDate", creationDate()).add("LastUpdateDate", lastUpdateDate())
                .add("RoleArn", roleArn()).add("Status", status()).add("PortalType", portalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "startUrl":
            return Optional.ofNullable(clazz.cast(startUrl()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "portalType":
            return Optional.ofNullable(clazz.cast(portalTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("startUrl", START_URL_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("portalType", PORTAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortalSummary, T> g) {
        return obj -> g.apply((PortalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortalSummary> {
        /**
         * <p>
         * The ID of the portal.
         * </p>
         * 
         * @param id
         *        The ID of the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the portal.
         * </p>
         * 
         * @param name
         *        The name of the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The portal's description.
         * </p>
         * 
         * @param description
         *        The portal's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity
         * Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console
         * to get a URL that you can use to access the portal.
         * </p>
         * 
         * @param startUrl
         *        The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM
         *        Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT
         *        SiteWise console to get a URL that you can use to access the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startUrl(String startUrl);

        /**
         * <p>
         * The date the portal was created, in Unix epoch time.
         * </p>
         * 
         * @param creationDate
         *        The date the portal was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the portal was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date the portal was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
         * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the service role that allows the portal's users to access your IoT SiteWise resources on your behalf.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using
         *        service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(PortalStatus status);

        /**
         * Sets the value of the Status property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PortalStatus.Builder} avoiding the need
         * to create one manually via {@link PortalStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortalStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(PortalStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link PortalStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(PortalStatus)
         */
        default Builder status(Consumer<PortalStatus.Builder> status) {
            return status(PortalStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>.
         * The value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
         * </p>
         * 
         * @param portalType
         *        Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
         *        <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
         *        <code>SITEWISE_PORTAL_V2</code>.
         * @see PortalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalType
         */
        Builder portalType(String portalType);

        /**
         * <p>
         * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>.
         * The value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
         * </p>
         * 
         * @param portalType
         *        Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
         *        <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
         *        <code>SITEWISE_PORTAL_V2</code>.
         * @see PortalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalType
         */
        Builder portalType(PortalType portalType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String startUrl;

        private Instant creationDate;

        private Instant lastUpdateDate;

        private String roleArn;

        private PortalStatus status;

        private String portalType;

        private BuilderImpl() {
        }

        private BuilderImpl(PortalSummary model) {
            id(model.id);
            name(model.name);
            description(model.description);
            startUrl(model.startUrl);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
            roleArn(model.roleArn);
            status(model.status);
            portalType(model.portalType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStartUrl() {
            return startUrl;
        }

        public final void setStartUrl(String startUrl) {
            this.startUrl = startUrl;
        }

        @Override
        public final Builder startUrl(String startUrl) {
            this.startUrl = startUrl;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final PortalStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(PortalStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(PortalStatus status) {
            this.status = status;
            return this;
        }

        public final String getPortalType() {
            return portalType;
        }

        public final void setPortalType(String portalType) {
            this.portalType = portalType;
        }

        @Override
        public final Builder portalType(String portalType) {
            this.portalType = portalType;
            return this;
        }

        @Override
        public final Builder portalType(PortalType portalType) {
            this.portalType(portalType == null ? null : portalType.toString());
            return this;
        }

        @Override
        public PortalSummary build() {
            return new PortalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
