/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExecutionsResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListExecutionsResponse.Builder, ListExecutionsResponse> {
    private static final SdkField<List<ExecutionSummary>> EXECUTION_SUMMARIES_FIELD = SdkField
            .<List<ExecutionSummary>> builder(MarshallingType.LIST)
            .memberName("executionSummaries")
            .getter(getter(ListExecutionsResponse::executionSummaries))
            .setter(setter(Builder::executionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ExecutionSummary> executionSummaries;

    private final String nextToken;

    private ListExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executionSummaries = builder.executionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionSummaries() {
        return executionSummaries != null && !(executionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the list of execution summaries of the computation models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionSummaries} method.
     * </p>
     * 
     * @return Contains the list of execution summaries of the computation models.
     */
    public final List<ExecutionSummary> executionSummaries() {
        return executionSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionSummaries() ? executionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResponse)) {
            return false;
        }
        ListExecutionsResponse other = (ListExecutionsResponse) obj;
        return hasExecutionSummaries() == other.hasExecutionSummaries()
                && Objects.equals(executionSummaries(), other.executionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExecutionsResponse")
                .add("ExecutionSummaries", hasExecutionSummaries() ? executionSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionSummaries":
            return Optional.ofNullable(clazz.cast(executionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionSummaries", EXECUTION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsResponse, T> g) {
        return obj -> g.apply((ListExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExecutionsResponse> {
        /**
         * <p>
         * Contains the list of execution summaries of the computation models.
         * </p>
         * 
         * @param executionSummaries
         *        Contains the list of execution summaries of the computation models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummaries(Collection<ExecutionSummary> executionSummaries);

        /**
         * <p>
         * Contains the list of execution summaries of the computation models.
         * </p>
         * 
         * @param executionSummaries
         *        Contains the list of execution summaries of the computation models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionSummaries(ExecutionSummary... executionSummaries);

        /**
         * <p>
         * Contains the list of execution summaries of the computation models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.ExecutionSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotsitewise.model.ExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.ExecutionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #executionSummaries(List<ExecutionSummary>)}.
         * 
         * @param executionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.ExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionSummaries(java.util.Collection<ExecutionSummary>)
         */
        Builder executionSummaries(Consumer<ExecutionSummary.Builder>... executionSummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<ExecutionSummary> executionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsResponse model) {
            super(model);
            executionSummaries(model.executionSummaries);
            nextToken(model.nextToken);
        }

        public final List<ExecutionSummary.Builder> getExecutionSummaries() {
            List<ExecutionSummary.Builder> result = ExecutionSummariesCopier.copyToBuilder(this.executionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionSummaries(Collection<ExecutionSummary.BuilderImpl> executionSummaries) {
            this.executionSummaries = ExecutionSummariesCopier.copyFromBuilder(executionSummaries);
        }

        @Override
        public final Builder executionSummaries(Collection<ExecutionSummary> executionSummaries) {
            this.executionSummaries = ExecutionSummariesCopier.copy(executionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(ExecutionSummary... executionSummaries) {
            executionSummaries(Arrays.asList(executionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(Consumer<ExecutionSummary.Builder>... executionSummaries) {
            executionSummaries(Stream.of(executionSummaries).map(c -> ExecutionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExecutionsResponse build() {
            return new ListExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
