/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComputationModelsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListComputationModelsRequest.Builder, ListComputationModelsRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelType").getter(getter(ListComputationModelsRequest::computationModelTypeAsString))
            .setter(setter(Builder::computationModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("computationModelType").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComputationModelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListComputationModelsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_TYPE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computationModelType;

    private final String nextToken;

    private final Integer maxResults;

    private ListComputationModelsRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelType = builder.computationModelType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The type of computation model. If a <code>computationModelType</code> is not provided, all types of computation
     * models are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #computationModelType} will return {@link ComputationModelType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #computationModelTypeAsString}.
     * </p>
     * 
     * @return The type of computation model. If a <code>computationModelType</code> is not provided, all types of
     *         computation models are returned.
     * @see ComputationModelType
     */
    public final ComputationModelType computationModelType() {
        return ComputationModelType.fromValue(computationModelType);
    }

    /**
     * <p>
     * The type of computation model. If a <code>computationModelType</code> is not provided, all types of computation
     * models are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #computationModelType} will return {@link ComputationModelType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #computationModelTypeAsString}.
     * </p>
     * 
     * @return The type of computation model. If a <code>computationModelType</code> is not provided, all types of
     *         computation models are returned.
     * @see ComputationModelType
     */
    public final String computationModelTypeAsString() {
        return computationModelType;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computationModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputationModelsRequest)) {
            return false;
        }
        ListComputationModelsRequest other = (ListComputationModelsRequest) obj;
        return Objects.equals(computationModelTypeAsString(), other.computationModelTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComputationModelsRequest").add("ComputationModelType", computationModelTypeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelType":
            return Optional.ofNullable(clazz.cast(computationModelTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelType", COMPUTATION_MODEL_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputationModelsRequest, T> g) {
        return obj -> g.apply((ListComputationModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListComputationModelsRequest> {
        /**
         * <p>
         * The type of computation model. If a <code>computationModelType</code> is not provided, all types of
         * computation models are returned.
         * </p>
         * 
         * @param computationModelType
         *        The type of computation model. If a <code>computationModelType</code> is not provided, all types of
         *        computation models are returned.
         * @see ComputationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationModelType
         */
        Builder computationModelType(String computationModelType);

        /**
         * <p>
         * The type of computation model. If a <code>computationModelType</code> is not provided, all types of
         * computation models are returned.
         * </p>
         * 
         * @param computationModelType
         *        The type of computation model. If a <code>computationModelType</code> is not provided, all types of
         *        computation models are returned.
         * @see ComputationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationModelType
         */
        Builder computationModelType(ComputationModelType computationModelType);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String computationModelType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputationModelsRequest model) {
            super(model);
            computationModelType(model.computationModelType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getComputationModelType() {
            return computationModelType;
        }

        public final void setComputationModelType(String computationModelType) {
            this.computationModelType = computationModelType;
        }

        @Override
        public final Builder computationModelType(String computationModelType) {
            this.computationModelType = computationModelType;
            return this;
        }

        @Override
        public final Builder computationModelType(ComputationModelType computationModelType) {
            this.computationModelType(computationModelType == null ? null : computationModelType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListComputationModelsRequest build() {
            return new ListComputationModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
