/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeAssistantRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<InvokeAssistantRequest.Builder, InvokeAssistantRequest> {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(InvokeAssistantRequest::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(InvokeAssistantRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrace").getter(getter(InvokeAssistantRequest::enableTrace)).setter(setter(Builder::enableTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD,
            MESSAGE_FIELD, ENABLE_TRACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String conversationId;

    private final String message;

    private final Boolean enableTrace;

    private InvokeAssistantRequest(BuilderImpl builder) {
        super(builder);
        this.conversationId = builder.conversationId;
        this.message = builder.message;
        this.enableTrace = builder.enableTrace;
    }

    /**
     * <p>
     * The ID assigned to a conversation. IoT SiteWise automatically generates a unique ID for you, and this parameter
     * is never required. However, if you prefer to have your own ID, you must specify it here in UUID format. If you
     * specify your own ID, it must be globally unique.
     * </p>
     * 
     * @return The ID assigned to a conversation. IoT SiteWise automatically generates a unique ID for you, and this
     *         parameter is never required. However, if you prefer to have your own ID, you must specify it here in UUID
     *         format. If you specify your own ID, it must be globally unique.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * A text message sent to the SiteWise Assistant by the user.
     * </p>
     * 
     * @return A text message sent to the SiteWise Assistant by the user.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Specifies if to turn trace on or not. It is used to track the SiteWise Assistant's reasoning, and data access
     * process.
     * </p>
     * 
     * @return Specifies if to turn trace on or not. It is used to track the SiteWise Assistant's reasoning, and data
     *         access process.
     */
    public final Boolean enableTrace() {
        return enableTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(enableTrace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAssistantRequest)) {
            return false;
        }
        InvokeAssistantRequest other = (InvokeAssistantRequest) obj;
        return Objects.equals(conversationId(), other.conversationId()) && Objects.equals(message(), other.message())
                && Objects.equals(enableTrace(), other.enableTrace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeAssistantRequest").add("ConversationId", conversationId())
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***").add("EnableTrace", enableTrace())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "enableTrace":
            return Optional.ofNullable(clazz.cast(enableTrace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAssistantRequest, T> g) {
        return obj -> g.apply((InvokeAssistantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeAssistantRequest> {
        /**
         * <p>
         * The ID assigned to a conversation. IoT SiteWise automatically generates a unique ID for you, and this
         * parameter is never required. However, if you prefer to have your own ID, you must specify it here in UUID
         * format. If you specify your own ID, it must be globally unique.
         * </p>
         * 
         * @param conversationId
         *        The ID assigned to a conversation. IoT SiteWise automatically generates a unique ID for you, and this
         *        parameter is never required. However, if you prefer to have your own ID, you must specify it here in
         *        UUID format. If you specify your own ID, it must be globally unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * A text message sent to the SiteWise Assistant by the user.
         * </p>
         * 
         * @param message
         *        A text message sent to the SiteWise Assistant by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Specifies if to turn trace on or not. It is used to track the SiteWise Assistant's reasoning, and data access
         * process.
         * </p>
         * 
         * @param enableTrace
         *        Specifies if to turn trace on or not. It is used to track the SiteWise Assistant's reasoning, and data
         *        access process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTrace(Boolean enableTrace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String conversationId;

        private String message;

        private Boolean enableTrace;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAssistantRequest model) {
            super(model);
            conversationId(model.conversationId);
            message(model.message);
            enableTrace(model.enableTrace);
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Boolean getEnableTrace() {
            return enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAssistantRequest build() {
            return new InvokeAssistantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
