/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for a gateway that runs on IoT Greengrass V2. To create a gateway that runs on IoT Greengrass V2,
 * you must deploy the IoT SiteWise Edge component to your gateway device. Your <a
 * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html">Greengrass device role</a>
 * must use the <code>AWSIoTSiteWiseEdgeAccess</code> policy. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html">Using IoT SiteWise at the edge</a>
 * in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GreengrassV2 implements SdkPojo, Serializable, ToCopyableBuilder<GreengrassV2.Builder, GreengrassV2> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceThingName").getter(getter(GreengrassV2::coreDeviceThingName))
            .setter(setter(Builder::coreDeviceThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceThingName").build())
            .build();

    private static final SdkField<String> CORE_DEVICE_OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coreDeviceOperatingSystem").getter(getter(GreengrassV2::coreDeviceOperatingSystemAsString))
            .setter(setter(Builder::coreDeviceOperatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceOperatingSystem").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD,
            CORE_DEVICE_OPERATING_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String coreDeviceThingName;

    private final String coreDeviceOperatingSystem;

    private GreengrassV2(BuilderImpl builder) {
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.coreDeviceOperatingSystem = builder.coreDeviceOperatingSystem;
    }

    /**
     * <p>
     * The name of the IoT thing for your IoT Greengrass V2 core device.
     * </p>
     * 
     * @return The name of the IoT thing for your IoT Greengrass V2 core device.
     */
    public final String coreDeviceThingName() {
        return coreDeviceThingName;
    }

    /**
     * <p>
     * The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required for
     * MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable for Classic stream, V2
     * gateways (<code>gatewayVersion</code> <code>2</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #coreDeviceOperatingSystem} will return {@link CoreDeviceOperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #coreDeviceOperatingSystemAsString}.
     * </p>
     * 
     * @return The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required
     *         for MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable for Classic
     *         stream, V2 gateways (<code>gatewayVersion</code> <code>2</code>).
     * @see CoreDeviceOperatingSystem
     */
    public final CoreDeviceOperatingSystem coreDeviceOperatingSystem() {
        return CoreDeviceOperatingSystem.fromValue(coreDeviceOperatingSystem);
    }

    /**
     * <p>
     * The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required for
     * MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable for Classic stream, V2
     * gateways (<code>gatewayVersion</code> <code>2</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #coreDeviceOperatingSystem} will return {@link CoreDeviceOperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #coreDeviceOperatingSystemAsString}.
     * </p>
     * 
     * @return The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required
     *         for MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable for Classic
     *         stream, V2 gateways (<code>gatewayVersion</code> <code>2</code>).
     * @see CoreDeviceOperatingSystem
     */
    public final String coreDeviceOperatingSystemAsString() {
        return coreDeviceOperatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(coreDeviceOperatingSystemAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreengrassV2)) {
            return false;
        }
        GreengrassV2 other = (GreengrassV2) obj;
        return Objects.equals(coreDeviceThingName(), other.coreDeviceThingName())
                && Objects.equals(coreDeviceOperatingSystemAsString(), other.coreDeviceOperatingSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GreengrassV2").add("CoreDeviceThingName", coreDeviceThingName())
                .add("CoreDeviceOperatingSystem", coreDeviceOperatingSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coreDeviceThingName":
            return Optional.ofNullable(clazz.cast(coreDeviceThingName()));
        case "coreDeviceOperatingSystem":
            return Optional.ofNullable(clazz.cast(coreDeviceOperatingSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coreDeviceThingName", CORE_DEVICE_THING_NAME_FIELD);
        map.put("coreDeviceOperatingSystem", CORE_DEVICE_OPERATING_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GreengrassV2, T> g) {
        return obj -> g.apply((GreengrassV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GreengrassV2> {
        /**
         * <p>
         * The name of the IoT thing for your IoT Greengrass V2 core device.
         * </p>
         * 
         * @param coreDeviceThingName
         *        The name of the IoT thing for your IoT Greengrass V2 core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreDeviceThingName(String coreDeviceThingName);

        /**
         * <p>
         * The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required for
         * MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable for Classic stream,
         * V2 gateways (<code>gatewayVersion</code> <code>2</code>).
         * </p>
         * 
         * @param coreDeviceOperatingSystem
         *        The operating system of the core device in IoT Greengrass V2. Specifying the operating system is
         *        required for MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable
         *        for Classic stream, V2 gateways (<code>gatewayVersion</code> <code>2</code>).
         * @see CoreDeviceOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreDeviceOperatingSystem
         */
        Builder coreDeviceOperatingSystem(String coreDeviceOperatingSystem);

        /**
         * <p>
         * The operating system of the core device in IoT Greengrass V2. Specifying the operating system is required for
         * MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable for Classic stream,
         * V2 gateways (<code>gatewayVersion</code> <code>2</code>).
         * </p>
         * 
         * @param coreDeviceOperatingSystem
         *        The operating system of the core device in IoT Greengrass V2. Specifying the operating system is
         *        required for MQTT-enabled, V3 gateways (<code>gatewayVersion</code> <code>3</code>) and not applicable
         *        for Classic stream, V2 gateways (<code>gatewayVersion</code> <code>2</code>).
         * @see CoreDeviceOperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreDeviceOperatingSystem
         */
        Builder coreDeviceOperatingSystem(CoreDeviceOperatingSystem coreDeviceOperatingSystem);
    }

    static final class BuilderImpl implements Builder {
        private String coreDeviceThingName;

        private String coreDeviceOperatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GreengrassV2 model) {
            coreDeviceThingName(model.coreDeviceThingName);
            coreDeviceOperatingSystem(model.coreDeviceOperatingSystem);
        }

        public final String getCoreDeviceThingName() {
            return coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final String getCoreDeviceOperatingSystem() {
            return coreDeviceOperatingSystem;
        }

        public final void setCoreDeviceOperatingSystem(String coreDeviceOperatingSystem) {
            this.coreDeviceOperatingSystem = coreDeviceOperatingSystem;
        }

        @Override
        public final Builder coreDeviceOperatingSystem(String coreDeviceOperatingSystem) {
            this.coreDeviceOperatingSystem = coreDeviceOperatingSystem;
            return this;
        }

        @Override
        public final Builder coreDeviceOperatingSystem(CoreDeviceOperatingSystem coreDeviceOperatingSystem) {
            this.coreDeviceOperatingSystem(coreDeviceOperatingSystem == null ? null : coreDeviceOperatingSystem.toString());
            return this;
        }

        @Override
        public GreengrassV2 build() {
            return new GreengrassV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
