/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeProjectResponse.Builder, DescribeProjectResponse> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(DescribeProjectResponse::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(DescribeProjectResponse::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(DescribeProjectResponse::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalId").getter(getter(DescribeProjectResponse::portalId)).setter(setter(Builder::portalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectDescription").getter(getter(DescribeProjectResponse::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectDescription").build())
            .build();

    private static final SdkField<Instant> PROJECT_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("projectCreationDate").getter(getter(DescribeProjectResponse::projectCreationDate))
            .setter(setter(Builder::projectCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectCreationDate").build())
            .build();

    private static final SdkField<Instant> PROJECT_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("projectLastUpdateDate").getter(getter(DescribeProjectResponse::projectLastUpdateDate))
            .setter(setter(Builder::projectLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectLastUpdateDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD,
            PROJECT_ARN_FIELD, PROJECT_NAME_FIELD, PORTAL_ID_FIELD, PROJECT_DESCRIPTION_FIELD, PROJECT_CREATION_DATE_FIELD,
            PROJECT_LAST_UPDATE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectId;

    private final String projectArn;

    private final String projectName;

    private final String portalId;

    private final String projectDescription;

    private final Instant projectCreationDate;

    private final Instant projectLastUpdateDate;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.portalId = builder.portalId;
        this.projectDescription = builder.projectDescription;
        this.projectCreationDate = builder.projectCreationDate;
        this.projectLastUpdateDate = builder.projectLastUpdateDate;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the project,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         project, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code>
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The ID of the portal that the project is in.
     * </p>
     * 
     * @return The ID of the portal that the project is in.
     */
    public final String portalId() {
        return portalId;
    }

    /**
     * <p>
     * The project's description.
     * </p>
     * 
     * @return The project's description.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * <p>
     * The date the project was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the project was created, in Unix epoch time.
     */
    public final Instant projectCreationDate() {
        return projectCreationDate;
    }

    /**
     * <p>
     * The date the project was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the project was last updated, in Unix epoch time.
     */
    public final Instant projectLastUpdateDate() {
        return projectLastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(portalId());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(projectCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(projectLastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse) obj;
        return Objects.equals(projectId(), other.projectId()) && Objects.equals(projectArn(), other.projectArn())
                && Objects.equals(projectName(), other.projectName()) && Objects.equals(portalId(), other.portalId())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(projectCreationDate(), other.projectCreationDate())
                && Objects.equals(projectLastUpdateDate(), other.projectLastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProjectResponse").add("ProjectId", projectId()).add("ProjectArn", projectArn())
                .add("ProjectName", projectName()).add("PortalId", portalId()).add("ProjectDescription", projectDescription())
                .add("ProjectCreationDate", projectCreationDate()).add("ProjectLastUpdateDate", projectLastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "portalId":
            return Optional.ofNullable(clazz.cast(portalId()));
        case "projectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "projectCreationDate":
            return Optional.ofNullable(clazz.cast(projectCreationDate()));
        case "projectLastUpdateDate":
            return Optional.ofNullable(clazz.cast(projectLastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("portalId", PORTAL_ID_FIELD);
        map.put("projectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("projectCreationDate", PROJECT_CREATION_DATE_FIELD);
        map.put("projectLastUpdateDate", PROJECT_LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectResponse> {
        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param projectId
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * project, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code>
         * </p>
         * 
         * @param projectArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the project, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:project/${ProjectId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The ID of the portal that the project is in.
         * </p>
         * 
         * @param portalId
         *        The ID of the portal that the project is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalId(String portalId);

        /**
         * <p>
         * The project's description.
         * </p>
         * 
         * @param projectDescription
         *        The project's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * <p>
         * The date the project was created, in Unix epoch time.
         * </p>
         * 
         * @param projectCreationDate
         *        The date the project was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectCreationDate(Instant projectCreationDate);

        /**
         * <p>
         * The date the project was last updated, in Unix epoch time.
         * </p>
         * 
         * @param projectLastUpdateDate
         *        The date the project was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectLastUpdateDate(Instant projectLastUpdateDate);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String projectId;

        private String projectArn;

        private String projectName;

        private String portalId;

        private String projectDescription;

        private Instant projectCreationDate;

        private Instant projectLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            projectId(model.projectId);
            projectArn(model.projectArn);
            projectName(model.projectName);
            portalId(model.portalId);
            projectDescription(model.projectDescription);
            projectCreationDate(model.projectCreationDate);
            projectLastUpdateDate(model.projectLastUpdateDate);
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getPortalId() {
            return portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final Instant getProjectCreationDate() {
            return projectCreationDate;
        }

        public final void setProjectCreationDate(Instant projectCreationDate) {
            this.projectCreationDate = projectCreationDate;
        }

        @Override
        public final Builder projectCreationDate(Instant projectCreationDate) {
            this.projectCreationDate = projectCreationDate;
            return this;
        }

        public final Instant getProjectLastUpdateDate() {
            return projectLastUpdateDate;
        }

        public final void setProjectLastUpdateDate(Instant projectLastUpdateDate) {
            this.projectLastUpdateDate = projectLastUpdateDate;
        }

        @Override
        public final Builder projectLastUpdateDate(Instant projectLastUpdateDate) {
            this.projectLastUpdateDate = projectLastUpdateDate;
            return this;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
