/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExecutionResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeExecutionResponse.Builder, DescribeExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(DescribeExecutionResponse::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(DescribeExecutionResponse::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField
            .<TargetResource> builder(MarshallingType.SDK_POJO).memberName("targetResource")
            .getter(getter(DescribeExecutionResponse::targetResource)).setter(setter(Builder::targetResource))
            .constructor(TargetResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()).build();

    private static final SdkField<String> TARGET_RESOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceVersion").getter(getter(DescribeExecutionResponse::targetResourceVersion))
            .setter(setter(Builder::targetResourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceVersion").build())
            .build();

    private static final SdkField<ResolveTo> RESOLVE_TO_FIELD = SdkField.<ResolveTo> builder(MarshallingType.SDK_POJO)
            .memberName("resolveTo").getter(getter(DescribeExecutionResponse::resolveTo)).setter(setter(Builder::resolveTo))
            .constructor(ResolveTo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveTo").build()).build();

    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionStartTime").getter(getter(DescribeExecutionResponse::executionStartTime))
            .setter(setter(Builder::executionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartTime").build())
            .build();

    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionEndTime").getter(getter(DescribeExecutionResponse::executionEndTime))
            .setter(setter(Builder::executionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEndTime").build()).build();

    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField
            .<ExecutionStatus> builder(MarshallingType.SDK_POJO).memberName("executionStatus")
            .getter(getter(DescribeExecutionResponse::executionStatus)).setter(setter(Builder::executionStatus))
            .constructor(ExecutionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()).build();

    private static final SdkField<Map<String, String>> EXECUTION_RESULT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("executionResult")
            .getter(getter(DescribeExecutionResponse::executionResult))
            .setter(setter(Builder::executionResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> EXECUTION_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("executionDetails")
            .getter(getter(DescribeExecutionResponse::executionDetails))
            .setter(setter(Builder::executionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ENTITY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionEntityVersion").getter(getter(DescribeExecutionResponse::executionEntityVersion))
            .setter(setter(Builder::executionEntityVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEntityVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            ACTION_TYPE_FIELD, TARGET_RESOURCE_FIELD, TARGET_RESOURCE_VERSION_FIELD, RESOLVE_TO_FIELD,
            EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, EXECUTION_STATUS_FIELD, EXECUTION_RESULT_FIELD,
            EXECUTION_DETAILS_FIELD, EXECUTION_ENTITY_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionId;

    private final String actionType;

    private final TargetResource targetResource;

    private final String targetResourceVersion;

    private final ResolveTo resolveTo;

    private final Instant executionStartTime;

    private final Instant executionEndTime;

    private final ExecutionStatus executionStatus;

    private final Map<String, String> executionResult;

    private final Map<String, String> executionDetails;

    private final String executionEntityVersion;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.actionType = builder.actionType;
        this.targetResource = builder.targetResource;
        this.targetResourceVersion = builder.targetResourceVersion;
        this.resolveTo = builder.resolveTo;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executionStatus = builder.executionStatus;
        this.executionResult = builder.executionResult;
        this.executionDetails = builder.executionDetails;
        this.executionEntityVersion = builder.executionEntityVersion;
    }

    /**
     * <p>
     * The ID of the execution.
     * </p>
     * 
     * @return The ID of the execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The type of action exectued.
     * </p>
     * 
     * @return The type of action exectued.
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * Returns the value of the TargetResource property for this object.
     * 
     * @return The value of the TargetResource property for this object.
     */
    public final TargetResource targetResource() {
        return targetResource;
    }

    /**
     * <p>
     * The version of the target resource.
     * </p>
     * 
     * @return The version of the target resource.
     */
    public final String targetResourceVersion() {
        return targetResourceVersion;
    }

    /**
     * <p>
     * The detailed resource this execution resolves to.
     * </p>
     * 
     * @return The detailed resource this execution resolves to.
     */
    public final ResolveTo resolveTo() {
        return resolveTo;
    }

    /**
     * <p>
     * The time the process started.
     * </p>
     * 
     * @return The time the process started.
     */
    public final Instant executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the process ended.
     * </p>
     * 
     * @return The time the process ended.
     */
    public final Instant executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The status of the execution process.
     * </p>
     * 
     * @return The status of the execution process.
     */
    public final ExecutionStatus executionStatus() {
        return executionStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionResult property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionResult() {
        return executionResult != null && !(executionResult instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The result of the execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionResult} method.
     * </p>
     * 
     * @return The result of the execution.
     */
    public final Map<String, String> executionResult() {
        return executionResult;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionDetails() {
        return executionDetails != null && !(executionDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Provides detailed information about the execution of your anomaly detection models. This includes model metrics
     * and training timestamps for both training and inference actions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The training action (Amazon Web Services/ANOMALY_DETECTION_TRAINING), includes performance metrics that help you
     * compare different versions of your anomaly detection models. These metrics provide insights into the model's
     * performance during the training process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inference action (Amazon Web Services/ANOMALY_DETECTION_INFERENCE), includes information about the results of
     * executing your anomaly detection models. This helps you understand the output of your models and assess their
     * performance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionDetails} method.
     * </p>
     * 
     * @return Provides detailed information about the execution of your anomaly detection models. This includes model
     *         metrics and training timestamps for both training and inference actions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The training action (Amazon Web Services/ANOMALY_DETECTION_TRAINING), includes performance metrics that
     *         help you compare different versions of your anomaly detection models. These metrics provide insights into
     *         the model's performance during the training process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The inference action (Amazon Web Services/ANOMALY_DETECTION_INFERENCE), includes information about the
     *         results of executing your anomaly detection models. This helps you understand the output of your models
     *         and assess their performance.
     *         </p>
     *         </li>
     */
    public final Map<String, String> executionDetails() {
        return executionDetails;
    }

    /**
     * <p>
     * Entity version used for the execution.
     * </p>
     * 
     * @return Entity version used for the execution.
     */
    public final String executionEntityVersion() {
        return executionEntityVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(resolveTo());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionResult() ? executionResult() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionDetails() ? executionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionEntityVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(actionType(), other.actionType())
                && Objects.equals(targetResource(), other.targetResource())
                && Objects.equals(targetResourceVersion(), other.targetResourceVersion())
                && Objects.equals(resolveTo(), other.resolveTo())
                && Objects.equals(executionStartTime(), other.executionStartTime())
                && Objects.equals(executionEndTime(), other.executionEndTime())
                && Objects.equals(executionStatus(), other.executionStatus())
                && hasExecutionResult() == other.hasExecutionResult()
                && Objects.equals(executionResult(), other.executionResult())
                && hasExecutionDetails() == other.hasExecutionDetails()
                && Objects.equals(executionDetails(), other.executionDetails())
                && Objects.equals(executionEntityVersion(), other.executionEntityVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExecutionResponse").add("ExecutionId", executionId()).add("ActionType", actionType())
                .add("TargetResource", targetResource()).add("TargetResourceVersion", targetResourceVersion())
                .add("ResolveTo", resolveTo()).add("ExecutionStartTime", executionStartTime())
                .add("ExecutionEndTime", executionEndTime()).add("ExecutionStatus", executionStatus())
                .add("ExecutionResult", hasExecutionResult() ? executionResult() : null)
                .add("ExecutionDetails", hasExecutionDetails() ? executionDetails() : null)
                .add("ExecutionEntityVersion", executionEntityVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "targetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        case "targetResourceVersion":
            return Optional.ofNullable(clazz.cast(targetResourceVersion()));
        case "resolveTo":
            return Optional.ofNullable(clazz.cast(resolveTo()));
        case "executionStartTime":
            return Optional.ofNullable(clazz.cast(executionStartTime()));
        case "executionEndTime":
            return Optional.ofNullable(clazz.cast(executionEndTime()));
        case "executionStatus":
            return Optional.ofNullable(clazz.cast(executionStatus()));
        case "executionResult":
            return Optional.ofNullable(clazz.cast(executionResult()));
        case "executionDetails":
            return Optional.ofNullable(clazz.cast(executionDetails()));
        case "executionEntityVersion":
            return Optional.ofNullable(clazz.cast(executionEntityVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        map.put("targetResourceVersion", TARGET_RESOURCE_VERSION_FIELD);
        map.put("resolveTo", RESOLVE_TO_FIELD);
        map.put("executionStartTime", EXECUTION_START_TIME_FIELD);
        map.put("executionEndTime", EXECUTION_END_TIME_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("executionResult", EXECUTION_RESULT_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        map.put("executionEntityVersion", EXECUTION_ENTITY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExecutionResponse> {
        /**
         * <p>
         * The ID of the execution.
         * </p>
         * 
         * @param executionId
         *        The ID of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The type of action exectued.
         * </p>
         * 
         * @param actionType
         *        The type of action exectued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * Sets the value of the TargetResource property for this object.
         *
         * @param targetResource
         *        The new value for the TargetResource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(TargetResource targetResource);

        /**
         * Sets the value of the TargetResource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TargetResource.Builder} avoiding the need
         * to create one manually via {@link TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetResource.Builder#build()} is called immediately and its
         * result is passed to {@link #targetResource(TargetResource)}.
         * 
         * @param targetResource
         *        a consumer that will call methods on {@link TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResource(TargetResource)
         */
        default Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return targetResource(TargetResource.builder().applyMutation(targetResource).build());
        }

        /**
         * <p>
         * The version of the target resource.
         * </p>
         * 
         * @param targetResourceVersion
         *        The version of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceVersion(String targetResourceVersion);

        /**
         * <p>
         * The detailed resource this execution resolves to.
         * </p>
         * 
         * @param resolveTo
         *        The detailed resource this execution resolves to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolveTo(ResolveTo resolveTo);

        /**
         * <p>
         * The detailed resource this execution resolves to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolveTo.Builder} avoiding the need to
         * create one manually via {@link ResolveTo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolveTo.Builder#build()} is called immediately and its result
         * is passed to {@link #resolveTo(ResolveTo)}.
         * 
         * @param resolveTo
         *        a consumer that will call methods on {@link ResolveTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolveTo(ResolveTo)
         */
        default Builder resolveTo(Consumer<ResolveTo.Builder> resolveTo) {
            return resolveTo(ResolveTo.builder().applyMutation(resolveTo).build());
        }

        /**
         * <p>
         * The time the process started.
         * </p>
         * 
         * @param executionStartTime
         *        The time the process started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Instant executionStartTime);

        /**
         * <p>
         * The time the process ended.
         * </p>
         * 
         * @param executionEndTime
         *        The time the process ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Instant executionEndTime);

        /**
         * <p>
         * The status of the execution process.
         * </p>
         * 
         * @param executionStatus
         *        The status of the execution process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatus(ExecutionStatus executionStatus);

        /**
         * <p>
         * The status of the execution process.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStatus.Builder} avoiding the
         * need to create one manually via {@link ExecutionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #executionStatus(ExecutionStatus)}.
         * 
         * @param executionStatus
         *        a consumer that will call methods on {@link ExecutionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStatus(ExecutionStatus)
         */
        default Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return executionStatus(ExecutionStatus.builder().applyMutation(executionStatus).build());
        }

        /**
         * <p>
         * The result of the execution.
         * </p>
         * 
         * @param executionResult
         *        The result of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionResult(Map<String, String> executionResult);

        /**
         * <p>
         * Provides detailed information about the execution of your anomaly detection models. This includes model
         * metrics and training timestamps for both training and inference actions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The training action (Amazon Web Services/ANOMALY_DETECTION_TRAINING), includes performance metrics that help
         * you compare different versions of your anomaly detection models. These metrics provide insights into the
         * model's performance during the training process.
         * </p>
         * </li>
         * <li>
         * <p>
         * The inference action (Amazon Web Services/ANOMALY_DETECTION_INFERENCE), includes information about the
         * results of executing your anomaly detection models. This helps you understand the output of your models and
         * assess their performance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param executionDetails
         *        Provides detailed information about the execution of your anomaly detection models. This includes
         *        model metrics and training timestamps for both training and inference actions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The training action (Amazon Web Services/ANOMALY_DETECTION_TRAINING), includes performance metrics
         *        that help you compare different versions of your anomaly detection models. These metrics provide
         *        insights into the model's performance during the training process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The inference action (Amazon Web Services/ANOMALY_DETECTION_INFERENCE), includes information about the
         *        results of executing your anomaly detection models. This helps you understand the output of your
         *        models and assess their performance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(Map<String, String> executionDetails);

        /**
         * <p>
         * Entity version used for the execution.
         * </p>
         * 
         * @param executionEntityVersion
         *        Entity version used for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEntityVersion(String executionEntityVersion);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String executionId;

        private String actionType;

        private TargetResource targetResource;

        private String targetResourceVersion;

        private ResolveTo resolveTo;

        private Instant executionStartTime;

        private Instant executionEndTime;

        private ExecutionStatus executionStatus;

        private Map<String, String> executionResult = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> executionDetails = DefaultSdkAutoConstructMap.getInstance();

        private String executionEntityVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            executionId(model.executionId);
            actionType(model.actionType);
            targetResource(model.targetResource);
            targetResourceVersion(model.targetResourceVersion);
            resolveTo(model.resolveTo);
            executionStartTime(model.executionStartTime);
            executionEndTime(model.executionEndTime);
            executionStatus(model.executionStatus);
            executionResult(model.executionResult);
            executionDetails(model.executionDetails);
            executionEntityVersion(model.executionEntityVersion);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return targetResource != null ? targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getTargetResourceVersion() {
            return targetResourceVersion;
        }

        public final void setTargetResourceVersion(String targetResourceVersion) {
            this.targetResourceVersion = targetResourceVersion;
        }

        @Override
        public final Builder targetResourceVersion(String targetResourceVersion) {
            this.targetResourceVersion = targetResourceVersion;
            return this;
        }

        public final ResolveTo.Builder getResolveTo() {
            return resolveTo != null ? resolveTo.toBuilder() : null;
        }

        public final void setResolveTo(ResolveTo.BuilderImpl resolveTo) {
            this.resolveTo = resolveTo != null ? resolveTo.build() : null;
        }

        @Override
        public final Builder resolveTo(ResolveTo resolveTo) {
            this.resolveTo = resolveTo;
            return this;
        }

        public final Instant getExecutionStartTime() {
            return executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return executionStatus != null ? executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public final Map<String, String> getExecutionResult() {
            if (executionResult instanceof SdkAutoConstructMap) {
                return null;
            }
            return executionResult;
        }

        public final void setExecutionResult(Map<String, String> executionResult) {
            this.executionResult = ExecutionResultCopier.copy(executionResult);
        }

        @Override
        public final Builder executionResult(Map<String, String> executionResult) {
            this.executionResult = ExecutionResultCopier.copy(executionResult);
            return this;
        }

        public final Map<String, String> getExecutionDetails() {
            if (executionDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return executionDetails;
        }

        public final void setExecutionDetails(Map<String, String> executionDetails) {
            this.executionDetails = ExecutionDetailsCopier.copy(executionDetails);
        }

        @Override
        public final Builder executionDetails(Map<String, String> executionDetails) {
            this.executionDetails = ExecutionDetailsCopier.copy(executionDetails);
            return this;
        }

        public final String getExecutionEntityVersion() {
            return executionEntityVersion;
        }

        public final void setExecutionEntityVersion(String executionEntityVersion) {
            this.executionEntityVersion = executionEntityVersion;
        }

        @Override
        public final Builder executionEntityVersion(String executionEntityVersion) {
            this.executionEntityVersion = executionEntityVersion;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
