/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputationModelExecutionSummaryResponse extends IoTSiteWiseResponse
        implements
        ToCopyableBuilder<DescribeComputationModelExecutionSummaryResponse.Builder, DescribeComputationModelExecutionSummaryResponse> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelId")
            .getter(getter(DescribeComputationModelExecutionSummaryResponse::computationModelId))
            .setter(setter(Builder::computationModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelId").build())
            .build();

    private static final SdkField<ResolveTo> RESOLVE_TO_FIELD = SdkField.<ResolveTo> builder(MarshallingType.SDK_POJO)
            .memberName("resolveTo").getter(getter(DescribeComputationModelExecutionSummaryResponse::resolveTo))
            .setter(setter(Builder::resolveTo)).constructor(ResolveTo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveTo").build()).build();

    private static final SdkField<Map<String, String>> COMPUTATION_MODEL_EXECUTION_SUMMARY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("computationModelExecutionSummary")
            .getter(getter(DescribeComputationModelExecutionSummaryResponse::computationModelExecutionSummary))
            .setter(setter(Builder::computationModelExecutionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelExecutionSummary")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD,
            RESOLVE_TO_FIELD, COMPUTATION_MODEL_EXECUTION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computationModelId;

    private final ResolveTo resolveTo;

    private final Map<String, String> computationModelExecutionSummary;

    private DescribeComputationModelExecutionSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.resolveTo = builder.resolveTo;
        this.computationModelExecutionSummary = builder.computationModelExecutionSummary;
    }

    /**
     * <p>
     * The ID of the computation model.
     * </p>
     * 
     * @return The ID of the computation model.
     */
    public final String computationModelId() {
        return computationModelId;
    }

    /**
     * <p>
     * The detailed resource this execution summary resolves to.
     * </p>
     * 
     * @return The detailed resource this execution summary resolves to.
     */
    public final ResolveTo resolveTo() {
        return resolveTo;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputationModelExecutionSummary
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasComputationModelExecutionSummary() {
        return computationModelExecutionSummary != null && !(computationModelExecutionSummary instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains the execution summary of the computation model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputationModelExecutionSummary}
     * method.
     * </p>
     * 
     * @return Contains the execution summary of the computation model.
     */
    public final Map<String, String> computationModelExecutionSummary() {
        return computationModelExecutionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(resolveTo());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasComputationModelExecutionSummary() ? computationModelExecutionSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelExecutionSummaryResponse)) {
            return false;
        }
        DescribeComputationModelExecutionSummaryResponse other = (DescribeComputationModelExecutionSummaryResponse) obj;
        return Objects.equals(computationModelId(), other.computationModelId()) && Objects.equals(resolveTo(), other.resolveTo())
                && hasComputationModelExecutionSummary() == other.hasComputationModelExecutionSummary()
                && Objects.equals(computationModelExecutionSummary(), other.computationModelExecutionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeComputationModelExecutionSummaryResponse")
                .add("ComputationModelId", computationModelId())
                .add("ResolveTo", resolveTo())
                .add("ComputationModelExecutionSummary",
                        hasComputationModelExecutionSummary() ? computationModelExecutionSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelId":
            return Optional.ofNullable(clazz.cast(computationModelId()));
        case "resolveTo":
            return Optional.ofNullable(clazz.cast(resolveTo()));
        case "computationModelExecutionSummary":
            return Optional.ofNullable(clazz.cast(computationModelExecutionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("resolveTo", RESOLVE_TO_FIELD);
        map.put("computationModelExecutionSummary", COMPUTATION_MODEL_EXECUTION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelExecutionSummaryResponse, T> g) {
        return obj -> g.apply((DescribeComputationModelExecutionSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComputationModelExecutionSummaryResponse> {
        /**
         * <p>
         * The ID of the computation model.
         * </p>
         * 
         * @param computationModelId
         *        The ID of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelId(String computationModelId);

        /**
         * <p>
         * The detailed resource this execution summary resolves to.
         * </p>
         * 
         * @param resolveTo
         *        The detailed resource this execution summary resolves to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolveTo(ResolveTo resolveTo);

        /**
         * <p>
         * The detailed resource this execution summary resolves to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolveTo.Builder} avoiding the need to
         * create one manually via {@link ResolveTo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolveTo.Builder#build()} is called immediately and its result
         * is passed to {@link #resolveTo(ResolveTo)}.
         * 
         * @param resolveTo
         *        a consumer that will call methods on {@link ResolveTo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolveTo(ResolveTo)
         */
        default Builder resolveTo(Consumer<ResolveTo.Builder> resolveTo) {
            return resolveTo(ResolveTo.builder().applyMutation(resolveTo).build());
        }

        /**
         * <p>
         * Contains the execution summary of the computation model.
         * </p>
         * 
         * @param computationModelExecutionSummary
         *        Contains the execution summary of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelExecutionSummary(Map<String, String> computationModelExecutionSummary);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String computationModelId;

        private ResolveTo resolveTo;

        private Map<String, String> computationModelExecutionSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelExecutionSummaryResponse model) {
            super(model);
            computationModelId(model.computationModelId);
            resolveTo(model.resolveTo);
            computationModelExecutionSummary(model.computationModelExecutionSummary);
        }

        public final String getComputationModelId() {
            return computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final ResolveTo.Builder getResolveTo() {
            return resolveTo != null ? resolveTo.toBuilder() : null;
        }

        public final void setResolveTo(ResolveTo.BuilderImpl resolveTo) {
            this.resolveTo = resolveTo != null ? resolveTo.build() : null;
        }

        @Override
        public final Builder resolveTo(ResolveTo resolveTo) {
            this.resolveTo = resolveTo;
            return this;
        }

        public final Map<String, String> getComputationModelExecutionSummary() {
            if (computationModelExecutionSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return computationModelExecutionSummary;
        }

        public final void setComputationModelExecutionSummary(Map<String, String> computationModelExecutionSummary) {
            this.computationModelExecutionSummary = ComputationModelExecutionSummaryCopier.copy(computationModelExecutionSummary);
        }

        @Override
        public final Builder computationModelExecutionSummary(Map<String, String> computationModelExecutionSummary) {
            this.computationModelExecutionSummary = ComputationModelExecutionSummaryCopier.copy(computationModelExecutionSummary);
            return this;
        }

        @Override
        public DescribeComputationModelExecutionSummaryResponse build() {
            return new DescribeComputationModelExecutionSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
