/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputationModelExecutionSummaryRequest extends IoTSiteWiseRequest
        implements
        ToCopyableBuilder<DescribeComputationModelExecutionSummaryRequest.Builder, DescribeComputationModelExecutionSummaryRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computationModelId").getter(getter(DescribeComputationModelExecutionSummaryRequest::computationModelId))
            .setter(setter(Builder::computationModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("computationModelId").build()).build();

    private static final SdkField<String> RESOLVE_TO_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolveToResourceType")
            .getter(getter(DescribeComputationModelExecutionSummaryRequest::resolveToResourceTypeAsString))
            .setter(setter(Builder::resolveToResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceType").build())
            .build();

    private static final SdkField<String> RESOLVE_TO_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolveToResourceId")
            .getter(getter(DescribeComputationModelExecutionSummaryRequest::resolveToResourceId))
            .setter(setter(Builder::resolveToResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD,
            RESOLVE_TO_RESOURCE_TYPE_FIELD, RESOLVE_TO_RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computationModelId;

    private final String resolveToResourceType;

    private final String resolveToResourceId;

    private DescribeComputationModelExecutionSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.resolveToResourceType = builder.resolveToResourceType;
        this.resolveToResourceId = builder.resolveToResourceId;
    }

    /**
     * <p>
     * The ID of the computation model.
     * </p>
     * 
     * @return The ID of the computation model.
     */
    public final String computationModelId() {
        return computationModelId;
    }

    /**
     * <p>
     * The type of the resolved resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolveToResourceType} will return {@link ResolveToResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolveToResourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resolved resource.
     * @see ResolveToResourceType
     */
    public final ResolveToResourceType resolveToResourceType() {
        return ResolveToResourceType.fromValue(resolveToResourceType);
    }

    /**
     * <p>
     * The type of the resolved resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resolveToResourceType} will return {@link ResolveToResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resolveToResourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resolved resource.
     * @see ResolveToResourceType
     */
    public final String resolveToResourceTypeAsString() {
        return resolveToResourceType;
    }

    /**
     * <p>
     * The ID of the resolved resource.
     * </p>
     * 
     * @return The ID of the resolved resource.
     */
    public final String resolveToResourceId() {
        return resolveToResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(resolveToResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolveToResourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelExecutionSummaryRequest)) {
            return false;
        }
        DescribeComputationModelExecutionSummaryRequest other = (DescribeComputationModelExecutionSummaryRequest) obj;
        return Objects.equals(computationModelId(), other.computationModelId())
                && Objects.equals(resolveToResourceTypeAsString(), other.resolveToResourceTypeAsString())
                && Objects.equals(resolveToResourceId(), other.resolveToResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComputationModelExecutionSummaryRequest")
                .add("ComputationModelId", computationModelId()).add("ResolveToResourceType", resolveToResourceTypeAsString())
                .add("ResolveToResourceId", resolveToResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computationModelId":
            return Optional.ofNullable(clazz.cast(computationModelId()));
        case "resolveToResourceType":
            return Optional.ofNullable(clazz.cast(resolveToResourceTypeAsString()));
        case "resolveToResourceId":
            return Optional.ofNullable(clazz.cast(resolveToResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("resolveToResourceType", RESOLVE_TO_RESOURCE_TYPE_FIELD);
        map.put("resolveToResourceId", RESOLVE_TO_RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelExecutionSummaryRequest, T> g) {
        return obj -> g.apply((DescribeComputationModelExecutionSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComputationModelExecutionSummaryRequest> {
        /**
         * <p>
         * The ID of the computation model.
         * </p>
         * 
         * @param computationModelId
         *        The ID of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationModelId(String computationModelId);

        /**
         * <p>
         * The type of the resolved resource.
         * </p>
         * 
         * @param resolveToResourceType
         *        The type of the resolved resource.
         * @see ResolveToResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveToResourceType
         */
        Builder resolveToResourceType(String resolveToResourceType);

        /**
         * <p>
         * The type of the resolved resource.
         * </p>
         * 
         * @param resolveToResourceType
         *        The type of the resolved resource.
         * @see ResolveToResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveToResourceType
         */
        Builder resolveToResourceType(ResolveToResourceType resolveToResourceType);

        /**
         * <p>
         * The ID of the resolved resource.
         * </p>
         * 
         * @param resolveToResourceId
         *        The ID of the resolved resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolveToResourceId(String resolveToResourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String computationModelId;

        private String resolveToResourceType;

        private String resolveToResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelExecutionSummaryRequest model) {
            super(model);
            computationModelId(model.computationModelId);
            resolveToResourceType(model.resolveToResourceType);
            resolveToResourceId(model.resolveToResourceId);
        }

        public final String getComputationModelId() {
            return computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getResolveToResourceType() {
            return resolveToResourceType;
        }

        public final void setResolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
        }

        @Override
        public final Builder resolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
            return this;
        }

        @Override
        public final Builder resolveToResourceType(ResolveToResourceType resolveToResourceType) {
            this.resolveToResourceType(resolveToResourceType == null ? null : resolveToResourceType.toString());
            return this;
        }

        public final String getResolveToResourceId() {
            return resolveToResourceId;
        }

        public final void setResolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
        }

        @Override
        public final Builder resolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputationModelExecutionSummaryRequest build() {
            return new DescribeComputationModelExecutionSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
