/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetModelInterfaceRelationshipRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DescribeAssetModelInterfaceRelationshipRequest.Builder, DescribeAssetModelInterfaceRelationshipRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DescribeAssetModelInterfaceRelationshipRequest::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()).build();

    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceAssetModelId")
            .getter(getter(DescribeAssetModelInterfaceRelationshipRequest::interfaceAssetModelId))
            .setter(setter(Builder::interfaceAssetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("interfaceAssetModelId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            INTERFACE_ASSET_MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String interfaceAssetModelId;

    private DescribeAssetModelInterfaceRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
    }

    /**
     * <p>
     * The ID of the asset model. This can be either the actual ID in UUID format, or else externalId: followed by the
     * external ID.
     * </p>
     * 
     * @return The ID of the asset model. This can be either the actual ID in UUID format, or else externalId: followed
     *         by the external ID.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of the interface asset model. This can be either the actual ID in UUID format, or else externalId:
     * followed by the external ID.
     * </p>
     * 
     * @return The ID of the interface asset model. This can be either the actual ID in UUID format, or else externalId:
     *         followed by the external ID.
     */
    public final String interfaceAssetModelId() {
        return interfaceAssetModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceAssetModelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelInterfaceRelationshipRequest)) {
            return false;
        }
        DescribeAssetModelInterfaceRelationshipRequest other = (DescribeAssetModelInterfaceRelationshipRequest) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(interfaceAssetModelId(), other.interfaceAssetModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetModelInterfaceRelationshipRequest").add("AssetModelId", assetModelId())
                .add("InterfaceAssetModelId", interfaceAssetModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "interfaceAssetModelId":
            return Optional.ofNullable(clazz.cast(interfaceAssetModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelInterfaceRelationshipRequest, T> g) {
        return obj -> g.apply((DescribeAssetModelInterfaceRelationshipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetModelInterfaceRelationshipRequest> {
        /**
         * <p>
         * The ID of the asset model. This can be either the actual ID in UUID format, or else externalId: followed by
         * the external ID.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model. This can be either the actual ID in UUID format, or else externalId:
         *        followed by the external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of the interface asset model. This can be either the actual ID in UUID format, or else externalId:
         * followed by the external ID.
         * </p>
         * 
         * @param interfaceAssetModelId
         *        The ID of the interface asset model. This can be either the actual ID in UUID format, or else
         *        externalId: followed by the external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceAssetModelId(String interfaceAssetModelId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelId;

        private String interfaceAssetModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelInterfaceRelationshipRequest model) {
            super(model);
            assetModelId(model.assetModelId);
            interfaceAssetModelId(model.interfaceAssetModelId);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getInterfaceAssetModelId() {
            return interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssetModelInterfaceRelationshipRequest build() {
            return new DescribeAssetModelInterfaceRelationshipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
