/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.eventstream.DefaultEventStreamResponseHandlerBuilder;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandlerFromBuilder;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeAssistantResponseHandlerBuilder extends
        DefaultEventStreamResponseHandlerBuilder<InvokeAssistantResponse, ResponseStream, InvokeAssistantResponseHandler.Builder>
        implements InvokeAssistantResponseHandler.Builder {
    @Override
    public InvokeAssistantResponseHandler.Builder subscriber(InvokeAssistantResponseHandler.Visitor visitor) {
        subscriber(e -> e.accept(visitor));
        return this;
    }

    @Override
    public InvokeAssistantResponseHandler build() {
        return new Impl(this);
    }

    @Generated("software.amazon.awssdk:codegen")
    private static final class Impl extends EventStreamResponseHandlerFromBuilder<InvokeAssistantResponse, ResponseStream>
            implements InvokeAssistantResponseHandler {
        private Impl(DefaultInvokeAssistantResponseHandlerBuilder builder) {
            super(builder);
        }
    }
}
