/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data source for the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSource implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSource.Builder, DatasetSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(DatasetSource::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<String> SOURCE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceFormat").getter(getter(DatasetSource::sourceFormatAsString)).setter(setter(Builder::sourceFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFormat").build()).build();

    private static final SdkField<SourceDetail> SOURCE_DETAIL_FIELD = SdkField.<SourceDetail> builder(MarshallingType.SDK_POJO)
            .memberName("sourceDetail").getter(getter(DatasetSource::sourceDetail)).setter(setter(Builder::sourceDetail))
            .constructor(SourceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            SOURCE_FORMAT_FIELD, SOURCE_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final String sourceFormat;

    private final SourceDetail sourceDetail;

    private DatasetSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceFormat = builder.sourceFormat;
        this.sourceDetail = builder.sourceDetail;
    }

    /**
     * <p>
     * The type of data source for the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link DatasetSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of data source for the dataset.
     * @see DatasetSourceType
     */
    public final DatasetSourceType sourceType() {
        return DatasetSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of data source for the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link DatasetSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of data source for the dataset.
     * @see DatasetSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The format of the dataset source associated with the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFormat} will
     * return {@link DatasetSourceFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceFormatAsString}.
     * </p>
     * 
     * @return The format of the dataset source associated with the dataset.
     * @see DatasetSourceFormat
     */
    public final DatasetSourceFormat sourceFormat() {
        return DatasetSourceFormat.fromValue(sourceFormat);
    }

    /**
     * <p>
     * The format of the dataset source associated with the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFormat} will
     * return {@link DatasetSourceFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceFormatAsString}.
     * </p>
     * 
     * @return The format of the dataset source associated with the dataset.
     * @see DatasetSourceFormat
     */
    public final String sourceFormatAsString() {
        return sourceFormat;
    }

    /**
     * <p>
     * The details of the dataset source associated with the dataset.
     * </p>
     * 
     * @return The details of the dataset source associated with the dataset.
     */
    public final SourceDetail sourceDetail() {
        return sourceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSource)) {
            return false;
        }
        DatasetSource other = (DatasetSource) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(sourceFormatAsString(), other.sourceFormatAsString())
                && Objects.equals(sourceDetail(), other.sourceDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetSource").add("SourceType", sourceTypeAsString())
                .add("SourceFormat", sourceFormatAsString()).add("SourceDetail", sourceDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "sourceFormat":
            return Optional.ofNullable(clazz.cast(sourceFormatAsString()));
        case "sourceDetail":
            return Optional.ofNullable(clazz.cast(sourceDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("sourceFormat", SOURCE_FORMAT_FIELD);
        map.put("sourceDetail", SOURCE_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetSource, T> g) {
        return obj -> g.apply((DatasetSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSource> {
        /**
         * <p>
         * The type of data source for the dataset.
         * </p>
         * 
         * @param sourceType
         *        The type of data source for the dataset.
         * @see DatasetSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of data source for the dataset.
         * </p>
         * 
         * @param sourceType
         *        The type of data source for the dataset.
         * @see DatasetSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetSourceType
         */
        Builder sourceType(DatasetSourceType sourceType);

        /**
         * <p>
         * The format of the dataset source associated with the dataset.
         * </p>
         * 
         * @param sourceFormat
         *        The format of the dataset source associated with the dataset.
         * @see DatasetSourceFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetSourceFormat
         */
        Builder sourceFormat(String sourceFormat);

        /**
         * <p>
         * The format of the dataset source associated with the dataset.
         * </p>
         * 
         * @param sourceFormat
         *        The format of the dataset source associated with the dataset.
         * @see DatasetSourceFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetSourceFormat
         */
        Builder sourceFormat(DatasetSourceFormat sourceFormat);

        /**
         * <p>
         * The details of the dataset source associated with the dataset.
         * </p>
         * 
         * @param sourceDetail
         *        The details of the dataset source associated with the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetail(SourceDetail sourceDetail);

        /**
         * <p>
         * The details of the dataset source associated with the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceDetail.Builder} avoiding the need
         * to create one manually via {@link SourceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceDetail(SourceDetail)}.
         * 
         * @param sourceDetail
         *        a consumer that will call methods on {@link SourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDetail(SourceDetail)
         */
        default Builder sourceDetail(Consumer<SourceDetail.Builder> sourceDetail) {
            return sourceDetail(SourceDetail.builder().applyMutation(sourceDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private String sourceFormat;

        private SourceDetail sourceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSource model) {
            sourceType(model.sourceType);
            sourceFormat(model.sourceFormat);
            sourceDetail(model.sourceDetail);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(DatasetSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getSourceFormat() {
            return sourceFormat;
        }

        public final void setSourceFormat(String sourceFormat) {
            this.sourceFormat = sourceFormat;
        }

        @Override
        public final Builder sourceFormat(String sourceFormat) {
            this.sourceFormat = sourceFormat;
            return this;
        }

        @Override
        public final Builder sourceFormat(DatasetSourceFormat sourceFormat) {
            this.sourceFormat(sourceFormat == null ? null : sourceFormat.toString());
            return this;
        }

        public final SourceDetail.Builder getSourceDetail() {
            return sourceDetail != null ? sourceDetail.toBuilder() : null;
        }

        public final void setSourceDetail(SourceDetail.BuilderImpl sourceDetail) {
            this.sourceDetail = sourceDetail != null ? sourceDetail.build() : null;
        }

        @Override
        public final Builder sourceDetail(SourceDetail sourceDetail) {
            this.sourceDetail = sourceDetail;
            return this;
        }

        @Override
        public DatasetSource build() {
            return new DatasetSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
