/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a value used in a data binding. It can be an asset property or an asset model property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataBindingValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DataBindingValue.Builder, DataBindingValue> {
    private static final SdkField<AssetModelPropertyBindingValue> ASSET_MODEL_PROPERTY_FIELD = SdkField
            .<AssetModelPropertyBindingValue> builder(MarshallingType.SDK_POJO).memberName("assetModelProperty")
            .getter(getter(DataBindingValue::assetModelProperty)).setter(setter(Builder::assetModelProperty))
            .constructor(AssetModelPropertyBindingValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperty").build())
            .build();

    private static final SdkField<AssetPropertyBindingValue> ASSET_PROPERTY_FIELD = SdkField
            .<AssetPropertyBindingValue> builder(MarshallingType.SDK_POJO).memberName("assetProperty")
            .getter(getter(DataBindingValue::assetProperty)).setter(setter(Builder::assetProperty))
            .constructor(AssetPropertyBindingValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperty").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_PROPERTY_FIELD,
            ASSET_PROPERTY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetModelPropertyBindingValue assetModelProperty;

    private final AssetPropertyBindingValue assetProperty;

    private DataBindingValue(BuilderImpl builder) {
        this.assetModelProperty = builder.assetModelProperty;
        this.assetProperty = builder.assetProperty;
    }

    /**
     * Returns the value of the AssetModelProperty property for this object.
     * 
     * @return The value of the AssetModelProperty property for this object.
     */
    public final AssetModelPropertyBindingValue assetModelProperty() {
        return assetModelProperty;
    }

    /**
     * <p>
     * The asset property value used in the data binding.
     * </p>
     * 
     * @return The asset property value used in the data binding.
     */
    public final AssetPropertyBindingValue assetProperty() {
        return assetProperty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelProperty());
        hashCode = 31 * hashCode + Objects.hashCode(assetProperty());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataBindingValue)) {
            return false;
        }
        DataBindingValue other = (DataBindingValue) obj;
        return Objects.equals(assetModelProperty(), other.assetModelProperty())
                && Objects.equals(assetProperty(), other.assetProperty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataBindingValue").add("AssetModelProperty", assetModelProperty())
                .add("AssetProperty", assetProperty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelProperty":
            return Optional.ofNullable(clazz.cast(assetModelProperty()));
        case "assetProperty":
            return Optional.ofNullable(clazz.cast(assetProperty()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelProperty", ASSET_MODEL_PROPERTY_FIELD);
        map.put("assetProperty", ASSET_PROPERTY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataBindingValue, T> g) {
        return obj -> g.apply((DataBindingValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataBindingValue> {
        /**
         * Sets the value of the AssetModelProperty property for this object.
         *
         * @param assetModelProperty
         *        The new value for the AssetModelProperty property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperty(AssetModelPropertyBindingValue assetModelProperty);

        /**
         * Sets the value of the AssetModelProperty property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AssetModelPropertyBindingValue.Builder}
         * avoiding the need to create one manually via {@link AssetModelPropertyBindingValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelPropertyBindingValue.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelProperty(AssetModelPropertyBindingValue)}.
         * 
         * @param assetModelProperty
         *        a consumer that will call methods on {@link AssetModelPropertyBindingValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperty(AssetModelPropertyBindingValue)
         */
        default Builder assetModelProperty(Consumer<AssetModelPropertyBindingValue.Builder> assetModelProperty) {
            return assetModelProperty(AssetModelPropertyBindingValue.builder().applyMutation(assetModelProperty).build());
        }

        /**
         * <p>
         * The asset property value used in the data binding.
         * </p>
         * 
         * @param assetProperty
         *        The asset property value used in the data binding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProperty(AssetPropertyBindingValue assetProperty);

        /**
         * <p>
         * The asset property value used in the data binding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetPropertyBindingValue.Builder}
         * avoiding the need to create one manually via {@link AssetPropertyBindingValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetPropertyBindingValue.Builder#build()} is called immediately
         * and its result is passed to {@link #assetProperty(AssetPropertyBindingValue)}.
         * 
         * @param assetProperty
         *        a consumer that will call methods on {@link AssetPropertyBindingValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProperty(AssetPropertyBindingValue)
         */
        default Builder assetProperty(Consumer<AssetPropertyBindingValue.Builder> assetProperty) {
            return assetProperty(AssetPropertyBindingValue.builder().applyMutation(assetProperty).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssetModelPropertyBindingValue assetModelProperty;

        private AssetPropertyBindingValue assetProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(DataBindingValue model) {
            assetModelProperty(model.assetModelProperty);
            assetProperty(model.assetProperty);
        }

        public final AssetModelPropertyBindingValue.Builder getAssetModelProperty() {
            return assetModelProperty != null ? assetModelProperty.toBuilder() : null;
        }

        public final void setAssetModelProperty(AssetModelPropertyBindingValue.BuilderImpl assetModelProperty) {
            this.assetModelProperty = assetModelProperty != null ? assetModelProperty.build() : null;
        }

        @Override
        public final Builder assetModelProperty(AssetModelPropertyBindingValue assetModelProperty) {
            this.assetModelProperty = assetModelProperty;
            return this;
        }

        public final AssetPropertyBindingValue.Builder getAssetProperty() {
            return assetProperty != null ? assetProperty.toBuilder() : null;
        }

        public final void setAssetProperty(AssetPropertyBindingValue.BuilderImpl assetProperty) {
            this.assetProperty = assetProperty != null ? assetProperty.build() : null;
        }

        @Override
        public final Builder assetProperty(AssetPropertyBindingValue assetProperty) {
            this.assetProperty = assetProperty;
            return this;
        }

        @Override
        public DataBindingValue build() {
            return new DataBindingValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
