/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<CreateDatasetResponse.Builder, CreateDatasetResponse> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(CreateDatasetResponse::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(CreateDatasetResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<DatasetStatus> DATASET_STATUS_FIELD = SdkField
            .<DatasetStatus> builder(MarshallingType.SDK_POJO).memberName("datasetStatus")
            .getter(getter(CreateDatasetResponse::datasetStatus)).setter(setter(Builder::datasetStatus))
            .constructor(DatasetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATASET_ARN_FIELD, DATASET_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetId;

    private final String datasetArn;

    private final DatasetStatus datasetStatus;

    private CreateDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetArn = builder.datasetArn;
        this.datasetStatus = builder.datasetStatus;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the dataset. The
     * format is <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the
     *         dataset. The format is
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code> after a
     * successfull call to this API, and any associated error message. The state is <code>ACTIVE</code> when ready to
     * use.
     * </p>
     * 
     * @return The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code>
     *         after a successfull call to this API, and any associated error message. The state is <code>ACTIVE</code>
     *         when ready to use.
     */
    public final DatasetStatus datasetStatus() {
        return datasetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetResponse)) {
            return false;
        }
        CreateDatasetResponse other = (CreateDatasetResponse) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(datasetStatus(), other.datasetStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetResponse").add("DatasetId", datasetId()).add("DatasetArn", datasetArn())
                .add("DatasetStatus", datasetStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "datasetStatus":
            return Optional.ofNullable(clazz.cast(datasetStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("datasetStatus", DATASET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetResponse, T> g) {
        return obj -> g.apply((CreateDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetResponse> {
        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param datasetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the dataset.
         * The format is <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
         * </p>
         * 
         * @param datasetArn
         *        The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html">ARN</a> of the
         *        dataset. The format is
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code>
         * after a successfull call to this API, and any associated error message. The state is <code>ACTIVE</code> when
         * ready to use.
         * </p>
         * 
         * @param datasetStatus
         *        The status of the dataset. This contains the state and any error messages. State is
         *        <code>CREATING</code> after a successfull call to this API, and any associated error message. The
         *        state is <code>ACTIVE</code> when ready to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetStatus(DatasetStatus datasetStatus);

        /**
         * <p>
         * The status of the dataset. This contains the state and any error messages. State is <code>CREATING</code>
         * after a successfull call to this API, and any associated error message. The state is <code>ACTIVE</code> when
         * ready to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetStatus.Builder} avoiding the need
         * to create one manually via {@link DatasetStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetStatus(DatasetStatus)}.
         * 
         * @param datasetStatus
         *        a consumer that will call methods on {@link DatasetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetStatus(DatasetStatus)
         */
        default Builder datasetStatus(Consumer<DatasetStatus.Builder> datasetStatus) {
            return datasetStatus(DatasetStatus.builder().applyMutation(datasetStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String datasetId;

        private String datasetArn;

        private DatasetStatus datasetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetResponse model) {
            super(model);
            datasetId(model.datasetId);
            datasetArn(model.datasetArn);
            datasetStatus(model.datasetStatus);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final DatasetStatus.Builder getDatasetStatus() {
            return datasetStatus != null ? datasetStatus.toBuilder() : null;
        }

        public final void setDatasetStatus(DatasetStatus.BuilderImpl datasetStatus) {
            this.datasetStatus = datasetStatus != null ? datasetStatus.build() : null;
        }

        @Override
        public final Builder datasetStatus(DatasetStatus datasetStatus) {
            this.datasetStatus = datasetStatus;
            return this;
        }

        @Override
        public CreateDatasetResponse build() {
            return new CreateDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
