/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a computation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationModelSummary.Builder, ComputationModelSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ComputationModelSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ComputationModelSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ComputationModelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ComputationModelSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ComputationModelSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ComputationModelSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(ComputationModelSummary::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final SdkField<ComputationModelStatus> STATUS_FIELD = SdkField
            .<ComputationModelStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(ComputationModelSummary::status)).setter(setter(Builder::status))
            .constructor(ComputationModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ComputationModelSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, STATUS_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final String type;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private final ComputationModelStatus status;

    private final String version;

    private ComputationModelSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.status = builder.status;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the computation model.
     * </p>
     * 
     * @return The ID of the computation model.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     * computation model, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         computation model, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the computation model.
     * </p>
     * 
     * @return The name of the computation model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the computation model.
     * </p>
     * 
     * @return The description of the computation model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the computation model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComputationModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the computation model.
     * @see ComputationModelType
     */
    public final ComputationModelType type() {
        return ComputationModelType.fromValue(type);
    }

    /**
     * <p>
     * The type of the computation model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComputationModelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the computation model.
     * @see ComputationModelType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The model creation date, in Unix epoch time.
     * </p>
     * 
     * @return The model creation date, in Unix epoch time.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time the model was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The time the model was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    /**
     * <p>
     * The current status of the computation model.
     * </p>
     * 
     * @return The current status of the computation model.
     */
    public final ComputationModelStatus status() {
        return status;
    }

    /**
     * <p>
     * The version of the computation model.
     * </p>
     * 
     * @return The version of the computation model.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelSummary)) {
            return false;
        }
        ComputationModelSummary other = (ComputationModelSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(status(), other.status())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationModelSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Type", typeAsString()).add("CreationDate", creationDate())
                .add("LastUpdateDate", lastUpdateDate()).add("Status", status()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelSummary, T> g) {
        return obj -> g.apply((ComputationModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationModelSummary> {
        /**
         * <p>
         * The ID of the computation model.
         * </p>
         * 
         * @param id
         *        The ID of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * computation model, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the computation model, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the computation model.
         * </p>
         * 
         * @param name
         *        The name of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the computation model.
         * </p>
         * 
         * @param description
         *        The description of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the computation model.
         * </p>
         * 
         * @param type
         *        The type of the computation model.
         * @see ComputationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationModelType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the computation model.
         * </p>
         * 
         * @param type
         *        The type of the computation model.
         * @see ComputationModelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputationModelType
         */
        Builder type(ComputationModelType type);

        /**
         * <p>
         * The model creation date, in Unix epoch time.
         * </p>
         * 
         * @param creationDate
         *        The model creation date, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time the model was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The time the model was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);

        /**
         * <p>
         * The current status of the computation model.
         * </p>
         * 
         * @param status
         *        The current status of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ComputationModelStatus status);

        /**
         * <p>
         * The current status of the computation model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationModelStatus.Builder} avoiding
         * the need to create one manually via {@link ComputationModelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationModelStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(ComputationModelStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ComputationModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ComputationModelStatus)
         */
        default Builder status(Consumer<ComputationModelStatus.Builder> status) {
            return status(ComputationModelStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The version of the computation model.
         * </p>
         * 
         * @param version
         *        The version of the computation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private String type;

        private Instant creationDate;

        private Instant lastUpdateDate;

        private ComputationModelStatus status;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            type(model.type);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
            status(model.status);
            version(model.version);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ComputationModelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final ComputationModelStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ComputationModelStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ComputationModelStatus status) {
            this.status = status;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ComputationModelSummary build() {
            return new ComputationModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
