/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration of the type of anomaly detection computation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputationModelAnomalyDetectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputationModelAnomalyDetectionConfiguration.Builder, ComputationModelAnomalyDetectionConfiguration> {
    private static final SdkField<String> INPUT_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputProperties").getter(getter(ComputationModelAnomalyDetectionConfiguration::inputProperties))
            .setter(setter(Builder::inputProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputProperties").build()).build();

    private static final SdkField<String> RESULT_PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultProperty").getter(getter(ComputationModelAnomalyDetectionConfiguration::resultProperty))
            .setter(setter(Builder::resultProperty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultProperty").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PROPERTIES_FIELD,
            RESULT_PROPERTY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputProperties;

    private final String resultProperty;

    private ComputationModelAnomalyDetectionConfiguration(BuilderImpl builder) {
        this.inputProperties = builder.inputProperties;
        this.resultProperty = builder.resultProperty;
    }

    /**
     * <p>
     * Define the variable name associated with input properties, with the following format <code>${VariableName}</code>
     * .
     * </p>
     * 
     * @return Define the variable name associated with input properties, with the following format
     *         <code>${VariableName}</code>.
     */
    public final String inputProperties() {
        return inputProperties;
    }

    /**
     * <p>
     * Define the variable name associated with the result property, and the following format
     * <code>${VariableName}</code>.
     * </p>
     * 
     * @return Define the variable name associated with the result property, and the following format
     *         <code>${VariableName}</code>.
     */
    public final String resultProperty() {
        return resultProperty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputProperties());
        hashCode = 31 * hashCode + Objects.hashCode(resultProperty());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputationModelAnomalyDetectionConfiguration)) {
            return false;
        }
        ComputationModelAnomalyDetectionConfiguration other = (ComputationModelAnomalyDetectionConfiguration) obj;
        return Objects.equals(inputProperties(), other.inputProperties())
                && Objects.equals(resultProperty(), other.resultProperty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputationModelAnomalyDetectionConfiguration").add("InputProperties", inputProperties())
                .add("ResultProperty", resultProperty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputProperties":
            return Optional.ofNullable(clazz.cast(inputProperties()));
        case "resultProperty":
            return Optional.ofNullable(clazz.cast(resultProperty()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputProperties", INPUT_PROPERTIES_FIELD);
        map.put("resultProperty", RESULT_PROPERTY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputationModelAnomalyDetectionConfiguration, T> g) {
        return obj -> g.apply((ComputationModelAnomalyDetectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputationModelAnomalyDetectionConfiguration> {
        /**
         * <p>
         * Define the variable name associated with input properties, with the following format
         * <code>${VariableName}</code>.
         * </p>
         * 
         * @param inputProperties
         *        Define the variable name associated with input properties, with the following format
         *        <code>${VariableName}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProperties(String inputProperties);

        /**
         * <p>
         * Define the variable name associated with the result property, and the following format
         * <code>${VariableName}</code>.
         * </p>
         * 
         * @param resultProperty
         *        Define the variable name associated with the result property, and the following format
         *        <code>${VariableName}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultProperty(String resultProperty);
    }

    static final class BuilderImpl implements Builder {
        private String inputProperties;

        private String resultProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputationModelAnomalyDetectionConfiguration model) {
            inputProperties(model.inputProperties);
            resultProperty(model.resultProperty);
        }

        public final String getInputProperties() {
            return inputProperties;
        }

        public final void setInputProperties(String inputProperties) {
            this.inputProperties = inputProperties;
        }

        @Override
        public final Builder inputProperties(String inputProperties) {
            this.inputProperties = inputProperties;
            return this;
        }

        public final String getResultProperty() {
            return resultProperty;
        }

        public final void setResultProperty(String resultProperty) {
            this.resultProperty = resultProperty;
        }

        @Override
        public final Builder resultProperty(String resultProperty) {
            this.resultProperty = resultProperty;
            return this;
        }

        @Override
        public ComputationModelAnomalyDetectionConfiguration build() {
            return new ComputationModelAnomalyDetectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
