/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutAssetPropertyValueRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<BatchPutAssetPropertyValueRequest.Builder, BatchPutAssetPropertyValueRequest> {
    private static final SdkField<Boolean> ENABLE_PARTIAL_ENTRY_PROCESSING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enablePartialEntryProcessing")
            .getter(getter(BatchPutAssetPropertyValueRequest::enablePartialEntryProcessing))
            .setter(setter(Builder::enablePartialEntryProcessing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePartialEntryProcessing")
                    .build()).build();

    private static final SdkField<List<PutAssetPropertyValueEntry>> ENTRIES_FIELD = SdkField
            .<List<PutAssetPropertyValueEntry>> builder(MarshallingType.LIST)
            .memberName("entries")
            .getter(getter(BatchPutAssetPropertyValueRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutAssetPropertyValueEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutAssetPropertyValueEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_PARTIAL_ENTRY_PROCESSING_FIELD, ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean enablePartialEntryProcessing;

    private final List<PutAssetPropertyValueEntry> entries;

    private BatchPutAssetPropertyValueRequest(BuilderImpl builder) {
        super(builder);
        this.enablePartialEntryProcessing = builder.enablePartialEntryProcessing;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * This setting enables partial ingestion at entry-level. If set to <code>true</code>, we ingest all TQVs not
     * resulting in an error. If set to <code>false</code>, an invalid TQV fails ingestion of the entire entry that
     * contains it.
     * </p>
     * 
     * @return This setting enables partial ingestion at entry-level. If set to <code>true</code>, we ingest all TQVs
     *         not resulting in an error. If set to <code>false</code>, an invalid TQV fails ingestion of the entire
     *         entry that contains it.
     */
    public final Boolean enablePartialEntryProcessing() {
        return enablePartialEntryProcessing;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of asset property value entries for the batch put request. You can specify up to 10 entries per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return The list of asset property value entries for the batch put request. You can specify up to 10 entries per
     *         request.
     */
    public final List<PutAssetPropertyValueEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enablePartialEntryProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAssetPropertyValueRequest)) {
            return false;
        }
        BatchPutAssetPropertyValueRequest other = (BatchPutAssetPropertyValueRequest) obj;
        return Objects.equals(enablePartialEntryProcessing(), other.enablePartialEntryProcessing())
                && hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutAssetPropertyValueRequest")
                .add("EnablePartialEntryProcessing", enablePartialEntryProcessing())
                .add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enablePartialEntryProcessing":
            return Optional.ofNullable(clazz.cast(enablePartialEntryProcessing()));
        case "entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enablePartialEntryProcessing", ENABLE_PARTIAL_ENTRY_PROCESSING_FIELD);
        map.put("entries", ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutAssetPropertyValueRequest, T> g) {
        return obj -> g.apply((BatchPutAssetPropertyValueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutAssetPropertyValueRequest> {
        /**
         * <p>
         * This setting enables partial ingestion at entry-level. If set to <code>true</code>, we ingest all TQVs not
         * resulting in an error. If set to <code>false</code>, an invalid TQV fails ingestion of the entire entry that
         * contains it.
         * </p>
         * 
         * @param enablePartialEntryProcessing
         *        This setting enables partial ingestion at entry-level. If set to <code>true</code>, we ingest all TQVs
         *        not resulting in an error. If set to <code>false</code>, an invalid TQV fails ingestion of the entire
         *        entry that contains it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePartialEntryProcessing(Boolean enablePartialEntryProcessing);

        /**
         * <p>
         * The list of asset property value entries for the batch put request. You can specify up to 10 entries per
         * request.
         * </p>
         * 
         * @param entries
         *        The list of asset property value entries for the batch put request. You can specify up to 10 entries
         *        per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<PutAssetPropertyValueEntry> entries);

        /**
         * <p>
         * The list of asset property value entries for the batch put request. You can specify up to 10 entries per
         * request.
         * </p>
         * 
         * @param entries
         *        The list of asset property value entries for the batch put request. You can specify up to 10 entries
         *        per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(PutAssetPropertyValueEntry... entries);

        /**
         * <p>
         * The list of asset property value entries for the batch put request. You can specify up to 10 entries per
         * request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry.Builder#build()} is
         * called immediately and its result is passed to {@link #entries(List<PutAssetPropertyValueEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.PutAssetPropertyValueEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<PutAssetPropertyValueEntry>)
         */
        Builder entries(Consumer<PutAssetPropertyValueEntry.Builder>... entries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private Boolean enablePartialEntryProcessing;

        private List<PutAssetPropertyValueEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutAssetPropertyValueRequest model) {
            super(model);
            enablePartialEntryProcessing(model.enablePartialEntryProcessing);
            entries(model.entries);
        }

        public final Boolean getEnablePartialEntryProcessing() {
            return enablePartialEntryProcessing;
        }

        public final void setEnablePartialEntryProcessing(Boolean enablePartialEntryProcessing) {
            this.enablePartialEntryProcessing = enablePartialEntryProcessing;
        }

        @Override
        public final Builder enablePartialEntryProcessing(Boolean enablePartialEntryProcessing) {
            this.enablePartialEntryProcessing = enablePartialEntryProcessing;
            return this;
        }

        public final List<PutAssetPropertyValueEntry.Builder> getEntries() {
            List<PutAssetPropertyValueEntry.Builder> result = PutAssetPropertyValueEntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<PutAssetPropertyValueEntry.BuilderImpl> entries) {
            this.entries = PutAssetPropertyValueEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<PutAssetPropertyValueEntry> entries) {
            this.entries = PutAssetPropertyValueEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutAssetPropertyValueEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutAssetPropertyValueEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> PutAssetPropertyValueEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutAssetPropertyValueRequest build() {
            return new BatchPutAssetPropertyValueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
