/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a property associated with an asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPropertySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetPropertySummary.Builder, AssetPropertySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetPropertySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(AssetPropertySummary::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(AssetPropertySummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(AssetPropertySummary::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField
            .<PropertyNotification> builder(MarshallingType.SDK_POJO).memberName("notification")
            .getter(getter(AssetPropertySummary::notification)).setter(setter(Builder::notification))
            .constructor(PropertyNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()).build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelId").getter(getter(AssetPropertySummary::assetCompositeModelId))
            .setter(setter(Builder::assetCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelId").build())
            .build();

    private static final SdkField<List<AssetPropertyPathSegment>> PATH_FIELD = SdkField
            .<List<AssetPropertyPathSegment>> builder(MarshallingType.LIST)
            .memberName("path")
            .getter(getter(AssetPropertySummary::path))
            .setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetPropertyPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetPropertyPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTERNAL_ID_FIELD,
            ALIAS_FIELD, UNIT_FIELD, NOTIFICATION_FIELD, ASSET_COMPOSITE_MODEL_ID_FIELD, PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String externalId;

    private final String alias;

    private final String unit;

    private final PropertyNotification notification;

    private final String assetCompositeModelId;

    private final List<AssetPropertyPathSegment> path;

    private AssetPropertySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.alias = builder.alias;
        this.unit = builder.unit;
        this.notification = builder.notification;
        this.assetCompositeModelId = builder.assetCompositeModelId;
        this.path = builder.path;
    }

    /**
     * <p>
     * The ID of the property.
     * </p>
     * 
     * @return The ID of the property.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The external ID of the property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The external ID of the property. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The unit of measure (such as Newtons or RPM) of the asset property.
     * </p>
     * 
     * @return The unit of measure (such as Newtons or RPM) of the asset property.
     */
    public final String unit() {
        return unit;
    }

    /**
     * Returns the value of the Notification property for this object.
     * 
     * @return The value of the Notification property for this object.
     */
    public final PropertyNotification notification() {
        return notification;
    }

    /**
     * <p>
     * The ID of the composite model that contains the asset property.
     * </p>
     * 
     * @return The ID of the composite model that contains the asset property.
     */
    public final String assetCompositeModelId() {
        return assetCompositeModelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Path property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPath() {
        return path != null && !(path instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The structured path to the property from the root of the asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPath} method.
     * </p>
     * 
     * @return The structured path to the property from the root of the asset.
     */
    public final List<AssetPropertyPathSegment> path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPath() ? path() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertySummary)) {
            return false;
        }
        AssetPropertySummary other = (AssetPropertySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(alias(), other.alias()) && Objects.equals(unit(), other.unit())
                && Objects.equals(notification(), other.notification())
                && Objects.equals(assetCompositeModelId(), other.assetCompositeModelId()) && hasPath() == other.hasPath()
                && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPropertySummary").add("Id", id()).add("ExternalId", externalId()).add("Alias", alias())
                .add("Unit", unit()).add("Notification", notification()).add("AssetCompositeModelId", assetCompositeModelId())
                .add("Path", hasPath() ? path() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "assetCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetCompositeModelId()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("notification", NOTIFICATION_FIELD);
        map.put("assetCompositeModelId", ASSET_COMPOSITE_MODEL_ID_FIELD);
        map.put("path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertySummary, T> g) {
        return obj -> g.apply((AssetPropertySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPropertySummary> {
        /**
         * <p>
         * The ID of the property.
         * </p>
         * 
         * @param id
         *        The ID of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The external ID of the property. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param externalId
         *        The external ID of the property. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param alias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The unit of measure (such as Newtons or RPM) of the asset property.
         * </p>
         * 
         * @param unit
         *        The unit of measure (such as Newtons or RPM) of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * Sets the value of the Notification property for this object.
         *
         * @param notification
         *        The new value for the Notification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(PropertyNotification notification);

        /**
         * Sets the value of the Notification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PropertyNotification.Builder} avoiding
         * the need to create one manually via {@link PropertyNotification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyNotification.Builder#build()} is called immediately and
         * its result is passed to {@link #notification(PropertyNotification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link PropertyNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(PropertyNotification)
         */
        default Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return notification(PropertyNotification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The ID of the composite model that contains the asset property.
         * </p>
         * 
         * @param assetCompositeModelId
         *        The ID of the composite model that contains the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelId(String assetCompositeModelId);

        /**
         * <p>
         * The structured path to the property from the root of the asset.
         * </p>
         * 
         * @param path
         *        The structured path to the property from the root of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(Collection<AssetPropertyPathSegment> path);

        /**
         * <p>
         * The structured path to the property from the root of the asset.
         * </p>
         * 
         * @param path
         *        The structured path to the property from the root of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(AssetPropertyPathSegment... path);

        /**
         * <p>
         * The structured path to the property from the root of the asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathSegment.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathSegment.Builder#build()} is called
         * immediately and its result is passed to {@link #path(List<AssetPropertyPathSegment>)}.
         * 
         * @param path
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(java.util.Collection<AssetPropertyPathSegment>)
         */
        Builder path(Consumer<AssetPropertyPathSegment.Builder>... path);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String externalId;

        private String alias;

        private String unit;

        private PropertyNotification notification;

        private String assetCompositeModelId;

        private List<AssetPropertyPathSegment> path = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertySummary model) {
            id(model.id);
            externalId(model.externalId);
            alias(model.alias);
            unit(model.unit);
            notification(model.notification);
            assetCompositeModelId(model.assetCompositeModelId);
            path(model.path);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyNotification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final String getAssetCompositeModelId() {
            return assetCompositeModelId;
        }

        public final void setAssetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
        }

        @Override
        public final Builder assetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
            return this;
        }

        public final List<AssetPropertyPathSegment.Builder> getPath() {
            List<AssetPropertyPathSegment.Builder> result = AssetPropertyPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetPropertyPathSegment.BuilderImpl> path) {
            this.path = AssetPropertyPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetPropertyPathSegment> path) {
            this.path = AssetPropertyPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetPropertyPathSegment... path) {
            path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetPropertyPathSegment.Builder>... path) {
            path(Stream.of(path).map(c -> AssetPropertyPathSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetPropertySummary build() {
            return new AssetPropertySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
