/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a property associated with a model. This includes information about which interfaces the
 * property belongs to, if any.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetModelPropertySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetModelPropertySummary.Builder, AssetModelPropertySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetModelPropertySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(AssetModelPropertySummary::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetModelPropertySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(AssetModelPropertySummary::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTypeSpec").getter(getter(AssetModelPropertySummary::dataTypeSpec))
            .setter(setter(Builder::dataTypeSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(AssetModelPropertySummary::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.<PropertyType> builder(MarshallingType.SDK_POJO)
            .memberName("type").getter(getter(AssetModelPropertySummary::type)).setter(setter(Builder::type))
            .constructor(PropertyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelId")
            .getter(getter(AssetModelPropertySummary::assetModelCompositeModelId))
            .setter(setter(Builder::assetModelCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelId").build())
            .build();

    private static final SdkField<List<AssetModelPropertyPathSegment>> PATH_FIELD = SdkField
            .<List<AssetModelPropertyPathSegment>> builder(MarshallingType.LIST)
            .memberName("path")
            .getter(getter(AssetModelPropertySummary::path))
            .setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelPropertyPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelPropertyPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InterfaceSummary>> INTERFACE_SUMMARIES_FIELD = SdkField
            .<List<InterfaceSummary>> builder(MarshallingType.LIST)
            .memberName("interfaceSummaries")
            .getter(getter(AssetModelPropertySummary::interfaceSummaries))
            .setter(setter(Builder::interfaceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InterfaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InterfaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTERNAL_ID_FIELD,
            NAME_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, UNIT_FIELD, TYPE_FIELD, ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD,
            PATH_FIELD, INTERFACE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String externalId;

    private final String name;

    private final String dataType;

    private final String dataTypeSpec;

    private final String unit;

    private final PropertyType type;

    private final String assetModelCompositeModelId;

    private final List<AssetModelPropertyPathSegment> path;

    private final List<InterfaceSummary> interfaceSummaries;

    private AssetModelPropertySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.unit = builder.unit;
        this.type = builder.type;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.path = builder.path;
        this.interfaceSummaries = builder.interfaceSummaries;
    }

    /**
     * <p>
     * The ID of the property.
     * </p>
     * 
     * @return The ID of the property.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The external ID of the property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The external ID of the property. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The name of the property.
     * </p>
     * 
     * @return The name of the property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the property.
     * @see PropertyDataType
     */
    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the property.
     * @see PropertyDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The data type of the structure for this property. This parameter exists on properties that have the
     * <code>STRUCT</code> data type.
     * </p>
     * 
     * @return The data type of the structure for this property. This parameter exists on properties that have the
     *         <code>STRUCT</code> data type.
     */
    public final String dataTypeSpec() {
        return dataTypeSpec;
    }

    /**
     * <p>
     * The unit (such as <code>Newtons</code> or <code>RPM</code>) of the property.
     * </p>
     * 
     * @return The unit (such as <code>Newtons</code> or <code>RPM</code>) of the property.
     */
    public final String unit() {
        return unit;
    }

    /**
     * Returns the value of the Type property for this object.
     * 
     * @return The value of the Type property for this object.
     */
    public final PropertyType type() {
        return type;
    }

    /**
     * <p>
     * The ID of the composite model that contains the asset model property.
     * </p>
     * 
     * @return The ID of the composite model that contains the asset model property.
     */
    public final String assetModelCompositeModelId() {
        return assetModelCompositeModelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Path property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPath() {
        return path != null && !(path instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The structured path to the property from the root of the asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPath} method.
     * </p>
     * 
     * @return The structured path to the property from the root of the asset model.
     */
    public final List<AssetModelPropertyPathSegment> path() {
        return path;
    }

    /**
     * For responses, this returns true if the service returned a value for the InterfaceSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInterfaceSummaries() {
        return interfaceSummaries != null && !(interfaceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of interface summaries that describe which interfaces this property belongs to, including the interface
     * asset model ID and the corresponding property ID in the interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterfaceSummaries} method.
     * </p>
     * 
     * @return A list of interface summaries that describe which interfaces this property belongs to, including the
     *         interface asset model ID and the corresponding property ID in the interface.
     */
    public final List<InterfaceSummary> interfaceSummaries() {
        return interfaceSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPath() ? path() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInterfaceSummaries() ? interfaceSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelPropertySummary)) {
            return false;
        }
        AssetModelPropertySummary other = (AssetModelPropertySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(name(), other.name()) && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(unit(), other.unit())
                && Objects.equals(type(), other.type())
                && Objects.equals(assetModelCompositeModelId(), other.assetModelCompositeModelId())
                && hasPath() == other.hasPath() && Objects.equals(path(), other.path())
                && hasInterfaceSummaries() == other.hasInterfaceSummaries()
                && Objects.equals(interfaceSummaries(), other.interfaceSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetModelPropertySummary").add("Id", id()).add("ExternalId", externalId()).add("Name", name())
                .add("DataType", dataTypeAsString()).add("DataTypeSpec", dataTypeSpec()).add("Unit", unit()).add("Type", type())
                .add("AssetModelCompositeModelId", assetModelCompositeModelId()).add("Path", hasPath() ? path() : null)
                .add("InterfaceSummaries", hasInterfaceSummaries() ? interfaceSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataTypeSpec":
            return Optional.ofNullable(clazz.cast(dataTypeSpec()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "assetModelCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelId()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "interfaceSummaries":
            return Optional.ofNullable(clazz.cast(interfaceSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dataTypeSpec", DATA_TYPE_SPEC_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("assetModelCompositeModelId", ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD);
        map.put("path", PATH_FIELD);
        map.put("interfaceSummaries", INTERFACE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetModelPropertySummary, T> g) {
        return obj -> g.apply((AssetModelPropertySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetModelPropertySummary> {
        /**
         * <p>
         * The ID of the property.
         * </p>
         * 
         * @param id
         *        The ID of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The external ID of the property. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param externalId
         *        The external ID of the property. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The name of the property.
         * </p>
         * 
         * @param name
         *        The name of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the property.
         * </p>
         * 
         * @param dataType
         *        The data type of the property.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the property.
         * </p>
         * 
         * @param dataType
         *        The data type of the property.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(PropertyDataType dataType);

        /**
         * <p>
         * The data type of the structure for this property. This parameter exists on properties that have the
         * <code>STRUCT</code> data type.
         * </p>
         * 
         * @param dataTypeSpec
         *        The data type of the structure for this property. This parameter exists on properties that have the
         *        <code>STRUCT</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeSpec(String dataTypeSpec);

        /**
         * <p>
         * The unit (such as <code>Newtons</code> or <code>RPM</code>) of the property.
         * </p>
         * 
         * @param unit
         *        The unit (such as <code>Newtons</code> or <code>RPM</code>) of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(PropertyType type);

        /**
         * Sets the value of the Type property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PropertyType.Builder} avoiding the need
         * to create one manually via {@link PropertyType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyType.Builder#build()} is called immediately and its
         * result is passed to {@link #type(PropertyType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link PropertyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(PropertyType)
         */
        default Builder type(Consumer<PropertyType.Builder> type) {
            return type(PropertyType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * The ID of the composite model that contains the asset model property.
         * </p>
         * 
         * @param assetModelCompositeModelId
         *        The ID of the composite model that contains the asset model property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelId(String assetModelCompositeModelId);

        /**
         * <p>
         * The structured path to the property from the root of the asset model.
         * </p>
         * 
         * @param path
         *        The structured path to the property from the root of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(Collection<AssetModelPropertyPathSegment> path);

        /**
         * <p>
         * The structured path to the property from the root of the asset model.
         * </p>
         * 
         * @param path
         *        The structured path to the property from the root of the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(AssetModelPropertyPathSegment... path);

        /**
         * <p>
         * The structured path to the property from the root of the asset model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment.Builder#build()} is
         * called immediately and its result is passed to {@link #path(List<AssetModelPropertyPathSegment>)}.
         * 
         * @param path
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertyPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(java.util.Collection<AssetModelPropertyPathSegment>)
         */
        Builder path(Consumer<AssetModelPropertyPathSegment.Builder>... path);

        /**
         * <p>
         * A list of interface summaries that describe which interfaces this property belongs to, including the
         * interface asset model ID and the corresponding property ID in the interface.
         * </p>
         * 
         * @param interfaceSummaries
         *        A list of interface summaries that describe which interfaces this property belongs to, including the
         *        interface asset model ID and the corresponding property ID in the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceSummaries(Collection<InterfaceSummary> interfaceSummaries);

        /**
         * <p>
         * A list of interface summaries that describe which interfaces this property belongs to, including the
         * interface asset model ID and the corresponding property ID in the interface.
         * </p>
         * 
         * @param interfaceSummaries
         *        A list of interface summaries that describe which interfaces this property belongs to, including the
         *        interface asset model ID and the corresponding property ID in the interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceSummaries(InterfaceSummary... interfaceSummaries);

        /**
         * <p>
         * A list of interface summaries that describe which interfaces this property belongs to, including the
         * interface asset model ID and the corresponding property ID in the interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #interfaceSummaries(List<InterfaceSummary>)}.
         * 
         * @param interfaceSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.InterfaceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceSummaries(java.util.Collection<InterfaceSummary>)
         */
        Builder interfaceSummaries(Consumer<InterfaceSummary.Builder>... interfaceSummaries);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String externalId;

        private String name;

        private String dataType;

        private String dataTypeSpec;

        private String unit;

        private PropertyType type;

        private String assetModelCompositeModelId;

        private List<AssetModelPropertyPathSegment> path = DefaultSdkAutoConstructList.getInstance();

        private List<InterfaceSummary> interfaceSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelPropertySummary model) {
            id(model.id);
            externalId(model.externalId);
            name(model.name);
            dataType(model.dataType);
            dataTypeSpec(model.dataTypeSpec);
            unit(model.unit);
            type(model.type);
            assetModelCompositeModelId(model.assetModelCompositeModelId);
            path(model.path);
            interfaceSummaries(model.interfaceSummaries);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final List<AssetModelPropertyPathSegment.Builder> getPath() {
            List<AssetModelPropertyPathSegment.Builder> result = AssetModelPropertyPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetModelPropertyPathSegment.BuilderImpl> path) {
            this.path = AssetModelPropertyPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetModelPropertyPathSegment> path) {
            this.path = AssetModelPropertyPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetModelPropertyPathSegment... path) {
            path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetModelPropertyPathSegment.Builder>... path) {
            path(Stream.of(path).map(c -> AssetModelPropertyPathSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InterfaceSummary.Builder> getInterfaceSummaries() {
            List<InterfaceSummary.Builder> result = InterfaceSummariesCopier.copyToBuilder(this.interfaceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceSummaries(Collection<InterfaceSummary.BuilderImpl> interfaceSummaries) {
            this.interfaceSummaries = InterfaceSummariesCopier.copyFromBuilder(interfaceSummaries);
        }

        @Override
        public final Builder interfaceSummaries(Collection<InterfaceSummary> interfaceSummaries) {
            this.interfaceSummaries = InterfaceSummariesCopier.copy(interfaceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceSummaries(InterfaceSummary... interfaceSummaries) {
            interfaceSummaries(Arrays.asList(interfaceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceSummaries(Consumer<InterfaceSummary.Builder>... interfaceSummaries) {
            interfaceSummaries(Stream.of(interfaceSummaries).map(c -> InterfaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetModelPropertySummary build() {
            return new AssetModelPropertySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
