/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an asset model property definition. This property definition is applied to all assets created from the asset
 * model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetModelPropertyDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetModelPropertyDefinition.Builder, AssetModelPropertyDefinition> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetModelPropertyDefinition::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(AssetModelPropertyDefinition::externalId))
            .setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetModelPropertyDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(AssetModelPropertyDefinition::dataTypeAsString))
            .setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTypeSpec").getter(getter(AssetModelPropertyDefinition::dataTypeSpec))
            .setter(setter(Builder::dataTypeSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(AssetModelPropertyDefinition::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.<PropertyType> builder(MarshallingType.SDK_POJO)
            .memberName("type").getter(getter(AssetModelPropertyDefinition::type)).setter(setter(Builder::type))
            .constructor(PropertyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTERNAL_ID_FIELD,
            NAME_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, UNIT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String externalId;

    private final String name;

    private final String dataType;

    private final String dataTypeSpec;

    private final String unit;

    private final PropertyType type;

    private AssetModelPropertyDefinition(BuilderImpl builder) {
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.unit = builder.unit;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID to assign to the asset model property, if desired. IoT SiteWise automatically generates a unique ID for
     * you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify
     * it here in UUID format. If you specify your own ID, it must be globally unique.
     * </p>
     * 
     * @return The ID to assign to the asset model property, if desired. IoT SiteWise automatically generates a unique
     *         ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead,
     *         you can specify it here in UUID format. If you specify your own ID, it must be globally unique.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * An external ID to assign to the property definition. The external ID must be unique among property definitions
     * within this asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return An external ID to assign to the property definition. The external ID must be unique among property
     *         definitions within this asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The name of the property definition.
     * </p>
     * 
     * @return The name of the property definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the property definition.
     * </p>
     * <p>
     * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the
     * structure for this property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the property definition.</p>
     *         <p>
     *         If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type
     *         of the structure for this property.
     * @see PropertyDataType
     */
    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the property definition.
     * </p>
     * <p>
     * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the
     * structure for this property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the property definition.</p>
     *         <p>
     *         If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type
     *         of the structure for this property.
     * @see PropertyDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The data type of the structure for this property. This parameter is required on properties that have the
     * <code>STRUCT</code> data type.
     * </p>
     * <p>
     * The options for this parameter depend on the type of the composite model in which you define this property. Use
     * <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.
     * </p>
     * 
     * @return The data type of the structure for this property. This parameter is required on properties that have the
     *         <code>STRUCT</code> data type.</p>
     *         <p>
     *         The options for this parameter depend on the type of the composite model in which you define this
     *         property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.
     */
    public final String dataTypeSpec() {
        return dataTypeSpec;
    }

    /**
     * <p>
     * The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.
     * </p>
     * 
     * @return The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The property definition type (see <code>PropertyType</code>). You can only specify one type in a property
     * definition.
     * </p>
     * 
     * @return The property definition type (see <code>PropertyType</code>). You can only specify one type in a property
     *         definition.
     */
    public final PropertyType type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelPropertyDefinition)) {
            return false;
        }
        AssetModelPropertyDefinition other = (AssetModelPropertyDefinition) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(name(), other.name()) && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(unit(), other.unit())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetModelPropertyDefinition").add("Id", id()).add("ExternalId", externalId())
                .add("Name", name()).add("DataType", dataTypeAsString()).add("DataTypeSpec", dataTypeSpec()).add("Unit", unit())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataTypeSpec":
            return Optional.ofNullable(clazz.cast(dataTypeSpec()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dataTypeSpec", DATA_TYPE_SPEC_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetModelPropertyDefinition, T> g) {
        return obj -> g.apply((AssetModelPropertyDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetModelPropertyDefinition> {
        /**
         * <p>
         * The ID to assign to the asset model property, if desired. IoT SiteWise automatically generates a unique ID
         * for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can
         * specify it here in UUID format. If you specify your own ID, it must be globally unique.
         * </p>
         * 
         * @param id
         *        The ID to assign to the asset model property, if desired. IoT SiteWise automatically generates a
         *        unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID
         *        instead, you can specify it here in UUID format. If you specify your own ID, it must be globally
         *        unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An external ID to assign to the property definition. The external ID must be unique among property
         * definitions within this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param externalId
         *        An external ID to assign to the property definition. The external ID must be unique among property
         *        definitions within this asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The name of the property definition.
         * </p>
         * 
         * @param name
         *        The name of the property definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the property definition.
         * </p>
         * <p>
         * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of
         * the structure for this property.
         * </p>
         * 
         * @param dataType
         *        The data type of the property definition.</p>
         *        <p>
         *        If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the
         *        type of the structure for this property.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the property definition.
         * </p>
         * <p>
         * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of
         * the structure for this property.
         * </p>
         * 
         * @param dataType
         *        The data type of the property definition.</p>
         *        <p>
         *        If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the
         *        type of the structure for this property.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(PropertyDataType dataType);

        /**
         * <p>
         * The data type of the structure for this property. This parameter is required on properties that have the
         * <code>STRUCT</code> data type.
         * </p>
         * <p>
         * The options for this parameter depend on the type of the composite model in which you define this property.
         * Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.
         * </p>
         * 
         * @param dataTypeSpec
         *        The data type of the structure for this property. This parameter is required on properties that have
         *        the <code>STRUCT</code> data type.</p>
         *        <p>
         *        The options for this parameter depend on the type of the composite model in which you define this
         *        property. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeSpec(String dataTypeSpec);

        /**
         * <p>
         * The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.
         * </p>
         * 
         * @param unit
         *        The unit of the property definition, such as <code>Newtons</code> or <code>RPM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The property definition type (see <code>PropertyType</code>). You can only specify one type in a property
         * definition.
         * </p>
         * 
         * @param type
         *        The property definition type (see <code>PropertyType</code>). You can only specify one type in a
         *        property definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(PropertyType type);

        /**
         * <p>
         * The property definition type (see <code>PropertyType</code>). You can only specify one type in a property
         * definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyType.Builder} avoiding the need
         * to create one manually via {@link PropertyType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyType.Builder#build()} is called immediately and its
         * result is passed to {@link #type(PropertyType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link PropertyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(PropertyType)
         */
        default Builder type(Consumer<PropertyType.Builder> type) {
            return type(PropertyType.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String externalId;

        private String name;

        private String dataType;

        private String dataTypeSpec;

        private String unit;

        private PropertyType type;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelPropertyDefinition model) {
            id(model.id);
            externalId(model.externalId);
            name(model.name);
            dataType(model.dataType);
            dataTypeSpec(model.dataTypeSpec);
            unit(model.unit);
            type(model.type);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        @Override
        public AssetModelPropertyDefinition build() {
            return new AssetModelPropertyDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
