/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelConfiguration;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingCopier;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComputationModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdateComputationModelRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelId").getter(UpdateComputationModelRequest.getter(UpdateComputationModelRequest::computationModelId)).setter(UpdateComputationModelRequest.setter(Builder::computationModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("computationModelId").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelName").getter(UpdateComputationModelRequest.getter(UpdateComputationModelRequest::computationModelName)).setter(UpdateComputationModelRequest.setter(Builder::computationModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelName").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelDescription").getter(UpdateComputationModelRequest.getter(UpdateComputationModelRequest::computationModelDescription)).setter(UpdateComputationModelRequest.setter(Builder::computationModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDescription").build()}).build();
    private static final SdkField<ComputationModelConfiguration> COMPUTATION_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computationModelConfiguration").getter(UpdateComputationModelRequest.getter(UpdateComputationModelRequest::computationModelConfiguration)).setter(UpdateComputationModelRequest.setter(Builder::computationModelConfiguration)).constructor(ComputationModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelConfiguration").build()}).build();
    private static final SdkField<Map<String, ComputationModelDataBindingValue>> COMPUTATION_MODEL_DATA_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("computationModelDataBinding").getter(UpdateComputationModelRequest.getter(UpdateComputationModelRequest::computationModelDataBinding)).setter(UpdateComputationModelRequest.setter(Builder::computationModelDataBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDataBinding").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputationModelDataBindingValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateComputationModelRequest.getter(UpdateComputationModelRequest::clientToken)).setter(UpdateComputationModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD, COMPUTATION_MODEL_NAME_FIELD, COMPUTATION_MODEL_DESCRIPTION_FIELD, COMPUTATION_MODEL_CONFIGURATION_FIELD, COMPUTATION_MODEL_DATA_BINDING_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateComputationModelRequest.memberNameToFieldInitializer();
    private final String computationModelId;
    private final String computationModelName;
    private final String computationModelDescription;
    private final ComputationModelConfiguration computationModelConfiguration;
    private final Map<String, ComputationModelDataBindingValue> computationModelDataBinding;
    private final String clientToken;

    private UpdateComputationModelRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelName = builder.computationModelName;
        this.computationModelDescription = builder.computationModelDescription;
        this.computationModelConfiguration = builder.computationModelConfiguration;
        this.computationModelDataBinding = builder.computationModelDataBinding;
        this.clientToken = builder.clientToken;
    }

    public final String computationModelId() {
        return this.computationModelId;
    }

    public final String computationModelName() {
        return this.computationModelName;
    }

    public final String computationModelDescription() {
        return this.computationModelDescription;
    }

    public final ComputationModelConfiguration computationModelConfiguration() {
        return this.computationModelConfiguration;
    }

    public final boolean hasComputationModelDataBinding() {
        return this.computationModelDataBinding != null && !(this.computationModelDataBinding instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComputationModelDataBindingValue> computationModelDataBinding() {
        return this.computationModelDataBinding;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputationModelDataBinding() ? this.computationModelDataBinding() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputationModelRequest)) {
            return false;
        }
        UpdateComputationModelRequest other = (UpdateComputationModelRequest)((Object)obj);
        return Objects.equals(this.computationModelId(), other.computationModelId()) && Objects.equals(this.computationModelName(), other.computationModelName()) && Objects.equals(this.computationModelDescription(), other.computationModelDescription()) && Objects.equals(this.computationModelConfiguration(), other.computationModelConfiguration()) && this.hasComputationModelDataBinding() == other.hasComputationModelDataBinding() && Objects.equals(this.computationModelDataBinding(), other.computationModelDataBinding()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComputationModelRequest").add("ComputationModelId", (Object)this.computationModelId()).add("ComputationModelName", (Object)this.computationModelName()).add("ComputationModelDescription", (Object)this.computationModelDescription()).add("ComputationModelConfiguration", (Object)this.computationModelConfiguration()).add("ComputationModelDataBinding", this.hasComputationModelDataBinding() ? this.computationModelDataBinding() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelId": {
                return Optional.ofNullable(clazz.cast(this.computationModelId()));
            }
            case "computationModelName": {
                return Optional.ofNullable(clazz.cast(this.computationModelName()));
            }
            case "computationModelDescription": {
                return Optional.ofNullable(clazz.cast(this.computationModelDescription()));
            }
            case "computationModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computationModelConfiguration()));
            }
            case "computationModelDataBinding": {
                return Optional.ofNullable(clazz.cast(this.computationModelDataBinding()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelName", COMPUTATION_MODEL_NAME_FIELD);
        map.put("computationModelDescription", COMPUTATION_MODEL_DESCRIPTION_FIELD);
        map.put("computationModelConfiguration", COMPUTATION_MODEL_CONFIGURATION_FIELD);
        map.put("computationModelDataBinding", COMPUTATION_MODEL_DATA_BINDING_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputationModelRequest, T> g) {
        return obj -> g.apply((UpdateComputationModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String computationModelId;
        private String computationModelName;
        private String computationModelDescription;
        private ComputationModelConfiguration computationModelConfiguration;
        private Map<String, ComputationModelDataBindingValue> computationModelDataBinding = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputationModelRequest model) {
            super(model);
            this.computationModelId(model.computationModelId);
            this.computationModelName(model.computationModelName);
            this.computationModelDescription(model.computationModelDescription);
            this.computationModelConfiguration(model.computationModelConfiguration);
            this.computationModelDataBinding(model.computationModelDataBinding);
            this.clientToken(model.clientToken);
        }

        public final String getComputationModelId() {
            return this.computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelName() {
            return this.computationModelName;
        }

        public final void setComputationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
        }

        @Override
        public final Builder computationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
            return this;
        }

        public final String getComputationModelDescription() {
            return this.computationModelDescription;
        }

        public final void setComputationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
        }

        @Override
        public final Builder computationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
            return this;
        }

        public final ComputationModelConfiguration.Builder getComputationModelConfiguration() {
            return this.computationModelConfiguration != null ? this.computationModelConfiguration.toBuilder() : null;
        }

        public final void setComputationModelConfiguration(ComputationModelConfiguration.BuilderImpl computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration != null ? computationModelConfiguration.build() : null;
        }

        @Override
        public final Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        public final Map<String, ComputationModelDataBindingValue.Builder> getComputationModelDataBinding() {
            Map<String, ComputationModelDataBindingValue.Builder> result = ComputationModelDataBindingCopier.copyToBuilder(this.computationModelDataBinding);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputationModelDataBinding(Map<String, ComputationModelDataBindingValue.BuilderImpl> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copyFromBuilder(computationModelDataBinding);
        }

        @Override
        public final Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copy(computationModelDataBinding);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputationModelRequest build() {
            return new UpdateComputationModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComputationModelRequest> {
        public Builder computationModelId(String var1);

        public Builder computationModelName(String var1);

        public Builder computationModelDescription(String var1);

        public Builder computationModelConfiguration(ComputationModelConfiguration var1);

        default public Builder computationModelConfiguration(Consumer<ComputationModelConfiguration.Builder> computationModelConfiguration) {
            return this.computationModelConfiguration((ComputationModelConfiguration)((ComputationModelConfiguration.Builder)ComputationModelConfiguration.builder().applyMutation(computationModelConfiguration)).build());
        }

        public Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

