/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.GroupIdentity;
import software.amazon.awssdk.services.iotsitewise.model.IAMRoleIdentity;
import software.amazon.awssdk.services.iotsitewise.model.IAMUserIdentity;
import software.amazon.awssdk.services.iotsitewise.model.UserIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Identity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Identity> {
    private static final SdkField<UserIdentity> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("user").getter(Identity.getter(Identity::user)).setter(Identity.setter(Builder::user)).constructor(UserIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<GroupIdentity> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("group").getter(Identity.getter(Identity::group)).setter(Identity.setter(Builder::group)).constructor(GroupIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<IAMUserIdentity> IAM_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamUser").getter(Identity.getter(Identity::iamUser)).setter(Identity.setter(Builder::iamUser)).constructor(IAMUserIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUser").build()}).build();
    private static final SdkField<IAMRoleIdentity> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamRole").getter(Identity.getter(Identity::iamRole)).setter(Identity.setter(Builder::iamRole)).constructor(IAMRoleIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, GROUP_FIELD, IAM_USER_FIELD, IAM_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Identity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UserIdentity user;
    private final GroupIdentity group;
    private final IAMUserIdentity iamUser;
    private final IAMRoleIdentity iamRole;

    private Identity(BuilderImpl builder) {
        this.user = builder.user;
        this.group = builder.group;
        this.iamUser = builder.iamUser;
        this.iamRole = builder.iamRole;
    }

    public final UserIdentity user() {
        return this.user;
    }

    public final GroupIdentity group() {
        return this.group;
    }

    public final IAMUserIdentity iamUser() {
        return this.iamUser;
    }

    public final IAMRoleIdentity iamRole() {
        return this.iamRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.iamUser(), other.iamUser()) && Objects.equals(this.iamRole(), other.iamRole());
    }

    public final String toString() {
        return ToString.builder((String)"Identity").add("User", (Object)this.user()).add("Group", (Object)this.group()).add("IamUser", (Object)this.iamUser()).add("IamRole", (Object)this.iamRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "iamUser": {
                return Optional.ofNullable(clazz.cast(this.iamUser()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user", USER_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("iamUser", IAM_USER_FIELD);
        map.put("iamRole", IAM_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UserIdentity user;
        private GroupIdentity group;
        private IAMUserIdentity iamUser;
        private IAMRoleIdentity iamRole;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            this.user(model.user);
            this.group(model.group);
            this.iamUser(model.iamUser);
            this.iamRole(model.iamRole);
        }

        public final UserIdentity.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(UserIdentity.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(UserIdentity user) {
            this.user = user;
            return this;
        }

        public final GroupIdentity.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(GroupIdentity.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        @Override
        public final Builder group(GroupIdentity group) {
            this.group = group;
            return this;
        }

        public final IAMUserIdentity.Builder getIamUser() {
            return this.iamUser != null ? this.iamUser.toBuilder() : null;
        }

        public final void setIamUser(IAMUserIdentity.BuilderImpl iamUser) {
            this.iamUser = iamUser != null ? iamUser.build() : null;
        }

        @Override
        public final Builder iamUser(IAMUserIdentity iamUser) {
            this.iamUser = iamUser;
            return this;
        }

        public final IAMRoleIdentity.Builder getIamRole() {
            return this.iamRole != null ? this.iamRole.toBuilder() : null;
        }

        public final void setIamRole(IAMRoleIdentity.BuilderImpl iamRole) {
            this.iamRole = iamRole != null ? iamRole.build() : null;
        }

        @Override
        public final Builder iamRole(IAMRoleIdentity iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public Identity build() {
            return new Identity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Identity> {
        public Builder user(UserIdentity var1);

        default public Builder user(Consumer<UserIdentity.Builder> user) {
            return this.user((UserIdentity)((UserIdentity.Builder)UserIdentity.builder().applyMutation(user)).build());
        }

        public Builder group(GroupIdentity var1);

        default public Builder group(Consumer<GroupIdentity.Builder> group) {
            return this.group((GroupIdentity)((GroupIdentity.Builder)GroupIdentity.builder().applyMutation(group)).build());
        }

        public Builder iamUser(IAMUserIdentity var1);

        default public Builder iamUser(Consumer<IAMUserIdentity.Builder> iamUser) {
            return this.iamUser((IAMUserIdentity)((IAMUserIdentity.Builder)IAMUserIdentity.builder().applyMutation(iamUser)).build());
        }

        public Builder iamRole(IAMRoleIdentity var1);

        default public Builder iamRole(Consumer<IAMRoleIdentity.Builder> iamRole) {
            return this.iamRole((IAMRoleIdentity)((IAMRoleIdentity.Builder)IAMRoleIdentity.builder().applyMutation(iamRole)).build());
        }
    }
}

