/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CoreDeviceOperatingSystem {
    LINUX_AARCH64("LINUX_AARCH64"),
    LINUX_AMD64("LINUX_AMD64"),
    WINDOWS_AMD64("WINDOWS_AMD64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CoreDeviceOperatingSystem> VALUE_MAP;
    private final String value;

    private CoreDeviceOperatingSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CoreDeviceOperatingSystem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CoreDeviceOperatingSystem> knownValues() {
        EnumSet<CoreDeviceOperatingSystem> knownValues = EnumSet.allOf(CoreDeviceOperatingSystem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CoreDeviceOperatingSystem.class, CoreDeviceOperatingSystem::toString);
    }
}

