/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapabilitySyncStatus {
    IN_SYNC("IN_SYNC"),
    OUT_OF_SYNC("OUT_OF_SYNC"),
    SYNC_FAILED("SYNC_FAILED"),
    UNKNOWN("UNKNOWN"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapabilitySyncStatus> VALUE_MAP;
    private final String value;

    private CapabilitySyncStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapabilitySyncStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapabilitySyncStatus> knownValues() {
        EnumSet<CapabilitySyncStatus> knownValues = EnumSet.allOf(CapabilitySyncStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapabilitySyncStatus.class, CapabilitySyncStatus::toString);
    }
}

