/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetHierarchiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy;
import software.amazon.awssdk.services.iotsitewise.model.AssetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedAssetsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedAssetsSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::id)).setter(AssociatedAssetsSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::arn)).setter(AssociatedAssetsSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::name)).setter(AssociatedAssetsSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::assetModelId)).setter(AssociatedAssetsSummary.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::creationDate)).setter(AssociatedAssetsSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateDate").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::lastUpdateDate)).setter(AssociatedAssetsSummary.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final SdkField<AssetStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::status)).setter(AssociatedAssetsSummary.setter(Builder::status)).constructor(AssetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<AssetHierarchy>> HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hierarchies").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::hierarchies)).setter(AssociatedAssetsSummary.setter(Builder::hierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::description)).setter(AssociatedAssetsSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(AssociatedAssetsSummary.getter(AssociatedAssetsSummary::externalId)).setter(AssociatedAssetsSummary.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, ASSET_MODEL_ID_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, STATUS_FIELD, HIERARCHIES_FIELD, DESCRIPTION_FIELD, EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociatedAssetsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String assetModelId;
    private final Instant creationDate;
    private final Instant lastUpdateDate;
    private final AssetStatus status;
    private final List<AssetHierarchy> hierarchies;
    private final String description;
    private final String externalId;

    private AssociatedAssetsSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.assetModelId = builder.assetModelId;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.status = builder.status;
        this.hierarchies = builder.hierarchies;
        this.description = builder.description;
        this.externalId = builder.externalId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public final AssetStatus status() {
        return this.status;
    }

    public final boolean hasHierarchies() {
        return this.hierarchies != null && !(this.hierarchies instanceof SdkAutoConstructList);
    }

    public final List<AssetHierarchy> hierarchies() {
        return this.hierarchies;
    }

    public final String description() {
        return this.description;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchies() ? this.hierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedAssetsSummary)) {
            return false;
        }
        AssociatedAssetsSummary other = (AssociatedAssetsSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(this.status(), other.status()) && this.hasHierarchies() == other.hasHierarchies() && Objects.equals(this.hierarchies(), other.hierarchies()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedAssetsSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("AssetModelId", (Object)this.assetModelId()).add("CreationDate", (Object)this.creationDate()).add("LastUpdateDate", (Object)this.lastUpdateDate()).add("Status", (Object)this.status()).add("Hierarchies", this.hasHierarchies() ? this.hierarchies() : null).add("Description", (Object)this.description()).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "hierarchies": {
                return Optional.ofNullable(clazz.cast(this.hierarchies()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("hierarchies", HIERARCHIES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedAssetsSummary, T> g) {
        return obj -> g.apply((AssociatedAssetsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String assetModelId;
        private Instant creationDate;
        private Instant lastUpdateDate;
        private AssetStatus status;
        private List<AssetHierarchy> hierarchies = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedAssetsSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.assetModelId(model.assetModelId);
            this.creationDate(model.creationDate);
            this.lastUpdateDate(model.lastUpdateDate);
            this.status(model.status);
            this.hierarchies(model.hierarchies);
            this.description(model.description);
            this.externalId(model.externalId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final AssetStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(AssetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AssetStatus status) {
            this.status = status;
            return this;
        }

        public final List<AssetHierarchy.Builder> getHierarchies() {
            List<AssetHierarchy.Builder> result = AssetHierarchiesCopier.copyToBuilder(this.hierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchies(Collection<AssetHierarchy.BuilderImpl> hierarchies) {
            this.hierarchies = AssetHierarchiesCopier.copyFromBuilder(hierarchies);
        }

        @Override
        public final Builder hierarchies(Collection<AssetHierarchy> hierarchies) {
            this.hierarchies = AssetHierarchiesCopier.copy(hierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchies(AssetHierarchy ... hierarchies) {
            this.hierarchies(Arrays.asList(hierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchies(Consumer<AssetHierarchy.Builder> ... hierarchies) {
            this.hierarchies(Stream.of(hierarchies).map(c -> (AssetHierarchy)((AssetHierarchy.Builder)AssetHierarchy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public AssociatedAssetsSummary build() {
            return new AssociatedAssetsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedAssetsSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder assetModelId(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdateDate(Instant var1);

        public Builder status(AssetStatus var1);

        default public Builder status(Consumer<AssetStatus.Builder> status) {
            return this.status((AssetStatus)((AssetStatus.Builder)AssetStatus.builder().applyMutation(status)).build());
        }

        public Builder hierarchies(Collection<AssetHierarchy> var1);

        public Builder hierarchies(AssetHierarchy ... var1);

        public Builder hierarchies(Consumer<AssetHierarchy.Builder> ... var1);

        public Builder description(String var1);

        public Builder externalId(String var1);
    }
}

