/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ComputeLocation;
import software.amazon.awssdk.services.iotsitewise.model.ForwardingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformProcessingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformProcessingConfig> {
    private static final SdkField<String> COMPUTE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeLocation").getter(TransformProcessingConfig.getter(TransformProcessingConfig::computeLocationAsString)).setter(TransformProcessingConfig.setter(Builder::computeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeLocation").build()}).build();
    private static final SdkField<ForwardingConfig> FORWARDING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("forwardingConfig").getter(TransformProcessingConfig.getter(TransformProcessingConfig::forwardingConfig)).setter(TransformProcessingConfig.setter(Builder::forwardingConfig)).constructor(ForwardingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forwardingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_LOCATION_FIELD, FORWARDING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformProcessingConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String computeLocation;
    private final ForwardingConfig forwardingConfig;

    private TransformProcessingConfig(BuilderImpl builder) {
        this.computeLocation = builder.computeLocation;
        this.forwardingConfig = builder.forwardingConfig;
    }

    public final ComputeLocation computeLocation() {
        return ComputeLocation.fromValue(this.computeLocation);
    }

    public final String computeLocationAsString() {
        return this.computeLocation;
    }

    public final ForwardingConfig forwardingConfig() {
        return this.forwardingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeLocationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformProcessingConfig)) {
            return false;
        }
        TransformProcessingConfig other = (TransformProcessingConfig)obj;
        return Objects.equals(this.computeLocationAsString(), other.computeLocationAsString()) && Objects.equals(this.forwardingConfig(), other.forwardingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"TransformProcessingConfig").add("ComputeLocation", (Object)this.computeLocationAsString()).add("ForwardingConfig", (Object)this.forwardingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeLocation": {
                return Optional.ofNullable(clazz.cast(this.computeLocationAsString()));
            }
            case "forwardingConfig": {
                return Optional.ofNullable(clazz.cast(this.forwardingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computeLocation", COMPUTE_LOCATION_FIELD);
        map.put("forwardingConfig", FORWARDING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformProcessingConfig, T> g) {
        return obj -> g.apply((TransformProcessingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeLocation;
        private ForwardingConfig forwardingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformProcessingConfig model) {
            this.computeLocation(model.computeLocation);
            this.forwardingConfig(model.forwardingConfig);
        }

        public final String getComputeLocation() {
            return this.computeLocation;
        }

        public final void setComputeLocation(String computeLocation) {
            this.computeLocation = computeLocation;
        }

        @Override
        public final Builder computeLocation(String computeLocation) {
            this.computeLocation = computeLocation;
            return this;
        }

        @Override
        public final Builder computeLocation(ComputeLocation computeLocation) {
            this.computeLocation(computeLocation == null ? null : computeLocation.toString());
            return this;
        }

        public final ForwardingConfig.Builder getForwardingConfig() {
            return this.forwardingConfig != null ? this.forwardingConfig.toBuilder() : null;
        }

        public final void setForwardingConfig(ForwardingConfig.BuilderImpl forwardingConfig) {
            this.forwardingConfig = forwardingConfig != null ? forwardingConfig.build() : null;
        }

        @Override
        public final Builder forwardingConfig(ForwardingConfig forwardingConfig) {
            this.forwardingConfig = forwardingConfig;
            return this;
        }

        public TransformProcessingConfig build() {
            return new TransformProcessingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformProcessingConfig> {
        public Builder computeLocation(String var1);

        public Builder computeLocation(ComputeLocation var1);

        public Builder forwardingConfig(ForwardingConfig var1);

        default public Builder forwardingConfig(Consumer<ForwardingConfig.Builder> forwardingConfig) {
            return this.forwardingConfig((ForwardingConfig)((ForwardingConfig.Builder)ForwardingConfig.builder().applyMutation(forwardingConfig)).build());
        }
    }
}

