/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ActionPayload;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TargetResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteActionRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, ExecuteActionRequest> {
    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetResource").getter(ExecuteActionRequest.getter(ExecuteActionRequest::targetResource)).setter(ExecuteActionRequest.setter(Builder::targetResource)).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()}).build();
    private static final SdkField<String> ACTION_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionDefinitionId").getter(ExecuteActionRequest.getter(ExecuteActionRequest::actionDefinitionId)).setter(ExecuteActionRequest.setter(Builder::actionDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitionId").build()}).build();
    private static final SdkField<ActionPayload> ACTION_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionPayload").getter(ExecuteActionRequest.getter(ExecuteActionRequest::actionPayload)).setter(ExecuteActionRequest.setter(Builder::actionPayload)).constructor(ActionPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPayload").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(ExecuteActionRequest.getter(ExecuteActionRequest::clientToken)).setter(ExecuteActionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_FIELD, ACTION_DEFINITION_ID_FIELD, ACTION_PAYLOAD_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteActionRequest.memberNameToFieldInitializer();
    private final TargetResource targetResource;
    private final String actionDefinitionId;
    private final ActionPayload actionPayload;
    private final String clientToken;

    private ExecuteActionRequest(BuilderImpl builder) {
        super(builder);
        this.targetResource = builder.targetResource;
        this.actionDefinitionId = builder.actionDefinitionId;
        this.actionPayload = builder.actionPayload;
        this.clientToken = builder.clientToken;
    }

    public final TargetResource targetResource() {
        return this.targetResource;
    }

    public final String actionDefinitionId() {
        return this.actionDefinitionId;
    }

    public final ActionPayload actionPayload() {
        return this.actionPayload;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteActionRequest)) {
            return false;
        }
        ExecuteActionRequest other = (ExecuteActionRequest)((Object)obj);
        return Objects.equals(this.targetResource(), other.targetResource()) && Objects.equals(this.actionDefinitionId(), other.actionDefinitionId()) && Objects.equals(this.actionPayload(), other.actionPayload()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteActionRequest").add("TargetResource", (Object)this.targetResource()).add("ActionDefinitionId", (Object)this.actionDefinitionId()).add("ActionPayload", (Object)this.actionPayload()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
            case "actionDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.actionDefinitionId()));
            }
            case "actionPayload": {
                return Optional.ofNullable(clazz.cast(this.actionPayload()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        map.put("actionDefinitionId", ACTION_DEFINITION_ID_FIELD);
        map.put("actionPayload", ACTION_PAYLOAD_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteActionRequest, T> g) {
        return obj -> g.apply((ExecuteActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private TargetResource targetResource;
        private String actionDefinitionId;
        private ActionPayload actionPayload;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteActionRequest model) {
            super(model);
            this.targetResource(model.targetResource);
            this.actionDefinitionId(model.actionDefinitionId);
            this.actionPayload(model.actionPayload);
            this.clientToken(model.clientToken);
        }

        public final TargetResource.Builder getTargetResource() {
            return this.targetResource != null ? this.targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getActionDefinitionId() {
            return this.actionDefinitionId;
        }

        public final void setActionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
        }

        @Override
        public final Builder actionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
            return this;
        }

        public final ActionPayload.Builder getActionPayload() {
            return this.actionPayload != null ? this.actionPayload.toBuilder() : null;
        }

        public final void setActionPayload(ActionPayload.BuilderImpl actionPayload) {
            this.actionPayload = actionPayload != null ? actionPayload.build() : null;
        }

        @Override
        public final Builder actionPayload(ActionPayload actionPayload) {
            this.actionPayload = actionPayload;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteActionRequest build() {
            return new ExecuteActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteActionRequest> {
        public Builder targetResource(TargetResource var1);

        default public Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return this.targetResource((TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation(targetResource)).build());
        }

        public Builder actionDefinitionId(String var1);

        public Builder actionPayload(ActionPayload var1);

        default public Builder actionPayload(Consumer<ActionPayload.Builder> actionPayload) {
            return this.actionPayload((ActionPayload)((ActionPayload.Builder)ActionPayload.builder().applyMutation(actionPayload)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

