/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iotsitewise.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iotsitewise.model.Row;

public class ExecuteQueryPublisher
implements SdkPublisher<ExecuteQueryResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ExecuteQueryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ExecuteQueryPublisher(IoTSiteWiseAsyncClient client, ExecuteQueryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ExecuteQueryPublisher(IoTSiteWiseAsyncClient client, ExecuteQueryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ExecuteQueryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ExecuteQueryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Row> rows() {
        Function<ExecuteQueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ExecuteQueryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ExecuteQueryResponseFetcher
    implements AsyncPageFetcher<ExecuteQueryResponse> {
        private ExecuteQueryResponseFetcher() {
        }

        public boolean hasNextPage(ExecuteQueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ExecuteQueryResponse> nextPage(ExecuteQueryResponse previousPage) {
            if (previousPage == null) {
                return ExecuteQueryPublisher.this.client.executeQuery(ExecuteQueryPublisher.this.firstRequest);
            }
            return ExecuteQueryPublisher.this.client.executeQuery((ExecuteQueryRequest)((Object)ExecuteQueryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

