/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus;
import software.amazon.awssdk.services.iotsitewise.model.DisassociatedDataStorageState;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage;
import software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod;
import software.amazon.awssdk.services.iotsitewise.model.StorageType;
import software.amazon.awssdk.services.iotsitewise.model.WarmTierRetentionPeriod;
import software.amazon.awssdk.services.iotsitewise.model.WarmTierState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageConfigurationResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeStorageConfigurationResponse> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::storageTypeAsString)).setter(DescribeStorageConfigurationResponse.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<MultiLayerStorage> MULTI_LAYER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("multiLayerStorage").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::multiLayerStorage)).setter(DescribeStorageConfigurationResponse.setter(Builder::multiLayerStorage)).constructor(MultiLayerStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiLayerStorage").build()}).build();
    private static final SdkField<String> DISASSOCIATED_DATA_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("disassociatedDataStorage").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::disassociatedDataStorageAsString)).setter(DescribeStorageConfigurationResponse.setter(Builder::disassociatedDataStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disassociatedDataStorage").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionPeriod").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::retentionPeriod)).setter(DescribeStorageConfigurationResponse.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<ConfigurationStatus> CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationStatus").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::configurationStatus)).setter(DescribeStorageConfigurationResponse.setter(Builder::configurationStatus)).constructor(ConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateDate").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::lastUpdateDate)).setter(DescribeStorageConfigurationResponse.setter(Builder::lastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()}).build();
    private static final SdkField<String> WARM_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warmTier").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::warmTierAsString)).setter(DescribeStorageConfigurationResponse.setter(Builder::warmTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warmTier").build()}).build();
    private static final SdkField<WarmTierRetentionPeriod> WARM_TIER_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("warmTierRetentionPeriod").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::warmTierRetentionPeriod)).setter(DescribeStorageConfigurationResponse.setter(Builder::warmTierRetentionPeriod)).constructor(WarmTierRetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warmTierRetentionPeriod").build()}).build();
    private static final SdkField<Boolean> DISALLOW_INGEST_NULL_NAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disallowIngestNullNaN").getter(DescribeStorageConfigurationResponse.getter(DescribeStorageConfigurationResponse::disallowIngestNullNaN)).setter(DescribeStorageConfigurationResponse.setter(Builder::disallowIngestNullNaN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disallowIngestNullNaN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, MULTI_LAYER_STORAGE_FIELD, DISASSOCIATED_DATA_STORAGE_FIELD, RETENTION_PERIOD_FIELD, CONFIGURATION_STATUS_FIELD, LAST_UPDATE_DATE_FIELD, WARM_TIER_FIELD, WARM_TIER_RETENTION_PERIOD_FIELD, DISALLOW_INGEST_NULL_NAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStorageConfigurationResponse.memberNameToFieldInitializer();
    private final String storageType;
    private final MultiLayerStorage multiLayerStorage;
    private final String disassociatedDataStorage;
    private final RetentionPeriod retentionPeriod;
    private final ConfigurationStatus configurationStatus;
    private final Instant lastUpdateDate;
    private final String warmTier;
    private final WarmTierRetentionPeriod warmTierRetentionPeriod;
    private final Boolean disallowIngestNullNaN;

    private DescribeStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.storageType = builder.storageType;
        this.multiLayerStorage = builder.multiLayerStorage;
        this.disassociatedDataStorage = builder.disassociatedDataStorage;
        this.retentionPeriod = builder.retentionPeriod;
        this.configurationStatus = builder.configurationStatus;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.warmTier = builder.warmTier;
        this.warmTierRetentionPeriod = builder.warmTierRetentionPeriod;
        this.disallowIngestNullNaN = builder.disallowIngestNullNaN;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final MultiLayerStorage multiLayerStorage() {
        return this.multiLayerStorage;
    }

    public final DisassociatedDataStorageState disassociatedDataStorage() {
        return DisassociatedDataStorageState.fromValue(this.disassociatedDataStorage);
    }

    public final String disassociatedDataStorageAsString() {
        return this.disassociatedDataStorage;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final ConfigurationStatus configurationStatus() {
        return this.configurationStatus;
    }

    public final Instant lastUpdateDate() {
        return this.lastUpdateDate;
    }

    public final WarmTierState warmTier() {
        return WarmTierState.fromValue(this.warmTier);
    }

    public final String warmTierAsString() {
        return this.warmTier;
    }

    public final WarmTierRetentionPeriod warmTierRetentionPeriod() {
        return this.warmTierRetentionPeriod;
    }

    public final Boolean disallowIngestNullNaN() {
        return this.disallowIngestNullNaN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiLayerStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociatedDataStorageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmTierRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.disallowIngestNullNaN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageConfigurationResponse)) {
            return false;
        }
        DescribeStorageConfigurationResponse other = (DescribeStorageConfigurationResponse)((Object)obj);
        return Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.multiLayerStorage(), other.multiLayerStorage()) && Objects.equals(this.disassociatedDataStorageAsString(), other.disassociatedDataStorageAsString()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.configurationStatus(), other.configurationStatus()) && Objects.equals(this.lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(this.warmTierAsString(), other.warmTierAsString()) && Objects.equals(this.warmTierRetentionPeriod(), other.warmTierRetentionPeriod()) && Objects.equals(this.disallowIngestNullNaN(), other.disallowIngestNullNaN());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageConfigurationResponse").add("StorageType", (Object)this.storageTypeAsString()).add("MultiLayerStorage", (Object)this.multiLayerStorage()).add("DisassociatedDataStorage", (Object)this.disassociatedDataStorageAsString()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("ConfigurationStatus", (Object)this.configurationStatus()).add("LastUpdateDate", (Object)this.lastUpdateDate()).add("WarmTier", (Object)this.warmTierAsString()).add("WarmTierRetentionPeriod", (Object)this.warmTierRetentionPeriod()).add("DisallowIngestNullNaN", (Object)this.disallowIngestNullNaN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "multiLayerStorage": {
                return Optional.ofNullable(clazz.cast(this.multiLayerStorage()));
            }
            case "disassociatedDataStorage": {
                return Optional.ofNullable(clazz.cast(this.disassociatedDataStorageAsString()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "configurationStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationStatus()));
            }
            case "lastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDate()));
            }
            case "warmTier": {
                return Optional.ofNullable(clazz.cast(this.warmTierAsString()));
            }
            case "warmTierRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.warmTierRetentionPeriod()));
            }
            case "disallowIngestNullNaN": {
                return Optional.ofNullable(clazz.cast(this.disallowIngestNullNaN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("multiLayerStorage", MULTI_LAYER_STORAGE_FIELD);
        map.put("disassociatedDataStorage", DISASSOCIATED_DATA_STORAGE_FIELD);
        map.put("retentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("configurationStatus", CONFIGURATION_STATUS_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        map.put("warmTier", WARM_TIER_FIELD);
        map.put("warmTierRetentionPeriod", WARM_TIER_RETENTION_PERIOD_FIELD);
        map.put("disallowIngestNullNaN", DISALLOW_INGEST_NULL_NAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeStorageConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String storageType;
        private MultiLayerStorage multiLayerStorage;
        private String disassociatedDataStorage;
        private RetentionPeriod retentionPeriod;
        private ConfigurationStatus configurationStatus;
        private Instant lastUpdateDate;
        private String warmTier;
        private WarmTierRetentionPeriod warmTierRetentionPeriod;
        private Boolean disallowIngestNullNaN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageConfigurationResponse model) {
            super(model);
            this.storageType(model.storageType);
            this.multiLayerStorage(model.multiLayerStorage);
            this.disassociatedDataStorage(model.disassociatedDataStorage);
            this.retentionPeriod(model.retentionPeriod);
            this.configurationStatus(model.configurationStatus);
            this.lastUpdateDate(model.lastUpdateDate);
            this.warmTier(model.warmTier);
            this.warmTierRetentionPeriod(model.warmTierRetentionPeriod);
            this.disallowIngestNullNaN(model.disallowIngestNullNaN);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final MultiLayerStorage.Builder getMultiLayerStorage() {
            return this.multiLayerStorage != null ? this.multiLayerStorage.toBuilder() : null;
        }

        public final void setMultiLayerStorage(MultiLayerStorage.BuilderImpl multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage != null ? multiLayerStorage.build() : null;
        }

        @Override
        public final Builder multiLayerStorage(MultiLayerStorage multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage;
            return this;
        }

        public final String getDisassociatedDataStorage() {
            return this.disassociatedDataStorage;
        }

        public final void setDisassociatedDataStorage(String disassociatedDataStorage) {
            this.disassociatedDataStorage = disassociatedDataStorage;
        }

        @Override
        public final Builder disassociatedDataStorage(String disassociatedDataStorage) {
            this.disassociatedDataStorage = disassociatedDataStorage;
            return this;
        }

        @Override
        public final Builder disassociatedDataStorage(DisassociatedDataStorageState disassociatedDataStorage) {
            this.disassociatedDataStorage(disassociatedDataStorage == null ? null : disassociatedDataStorage.toString());
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final ConfigurationStatus.Builder getConfigurationStatus() {
            return this.configurationStatus != null ? this.configurationStatus.toBuilder() : null;
        }

        public final void setConfigurationStatus(ConfigurationStatus.BuilderImpl configurationStatus) {
            this.configurationStatus = configurationStatus != null ? configurationStatus.build() : null;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final String getWarmTier() {
            return this.warmTier;
        }

        public final void setWarmTier(String warmTier) {
            this.warmTier = warmTier;
        }

        @Override
        public final Builder warmTier(String warmTier) {
            this.warmTier = warmTier;
            return this;
        }

        @Override
        public final Builder warmTier(WarmTierState warmTier) {
            this.warmTier(warmTier == null ? null : warmTier.toString());
            return this;
        }

        public final WarmTierRetentionPeriod.Builder getWarmTierRetentionPeriod() {
            return this.warmTierRetentionPeriod != null ? this.warmTierRetentionPeriod.toBuilder() : null;
        }

        public final void setWarmTierRetentionPeriod(WarmTierRetentionPeriod.BuilderImpl warmTierRetentionPeriod) {
            this.warmTierRetentionPeriod = warmTierRetentionPeriod != null ? warmTierRetentionPeriod.build() : null;
        }

        @Override
        public final Builder warmTierRetentionPeriod(WarmTierRetentionPeriod warmTierRetentionPeriod) {
            this.warmTierRetentionPeriod = warmTierRetentionPeriod;
            return this;
        }

        public final Boolean getDisallowIngestNullNaN() {
            return this.disallowIngestNullNaN;
        }

        public final void setDisallowIngestNullNaN(Boolean disallowIngestNullNaN) {
            this.disallowIngestNullNaN = disallowIngestNullNaN;
        }

        @Override
        public final Builder disallowIngestNullNaN(Boolean disallowIngestNullNaN) {
            this.disallowIngestNullNaN = disallowIngestNullNaN;
            return this;
        }

        @Override
        public DescribeStorageConfigurationResponse build() {
            return new DescribeStorageConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageConfigurationResponse> {
        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder multiLayerStorage(MultiLayerStorage var1);

        default public Builder multiLayerStorage(Consumer<MultiLayerStorage.Builder> multiLayerStorage) {
            return this.multiLayerStorage((MultiLayerStorage)((MultiLayerStorage.Builder)MultiLayerStorage.builder().applyMutation(multiLayerStorage)).build());
        }

        public Builder disassociatedDataStorage(String var1);

        public Builder disassociatedDataStorage(DisassociatedDataStorageState var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder configurationStatus(ConfigurationStatus var1);

        default public Builder configurationStatus(Consumer<ConfigurationStatus.Builder> configurationStatus) {
            return this.configurationStatus((ConfigurationStatus)((ConfigurationStatus.Builder)ConfigurationStatus.builder().applyMutation(configurationStatus)).build());
        }

        public Builder lastUpdateDate(Instant var1);

        public Builder warmTier(String var1);

        public Builder warmTier(WarmTierState var1);

        public Builder warmTierRetentionPeriod(WarmTierRetentionPeriod var1);

        default public Builder warmTierRetentionPeriod(Consumer<WarmTierRetentionPeriod.Builder> warmTierRetentionPeriod) {
            return this.warmTierRetentionPeriod((WarmTierRetentionPeriod)((WarmTierRetentionPeriod.Builder)WarmTierRetentionPeriod.builder().applyMutation(warmTierRetentionPeriod)).build());
        }

        public Builder disallowIngestNullNaN(Boolean var1);
    }
}

