/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.DatasetSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListDatasetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListDatasetsResponse;

public class ListDatasetsIterable
implements SdkIterable<ListDatasetsResponse> {
    private final IoTSiteWiseClient client;
    private final ListDatasetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetsIterable(IoTSiteWiseClient client, ListDatasetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasetsResponseFetcher();
    }

    public Iterator<ListDatasetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatasetSummary> datasetSummaries() {
        Function<ListDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetSummaries() != null) {
                return response.datasetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetsResponseFetcher
    implements SyncPageFetcher<ListDatasetsResponse> {
        private ListDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetsResponse nextPage(ListDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetsIterable.this.client.listDatasets(ListDatasetsIterable.this.firstRequest);
            }
            return ListDatasetsIterable.this.client.listDatasets((ListDatasetsRequest)((Object)ListDatasetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

