/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PortalType {
    SITEWISE_PORTAL_V1("SITEWISE_PORTAL_V1"),
    SITEWISE_PORTAL_V2("SITEWISE_PORTAL_V2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PortalType> VALUE_MAP;
    private final String value;

    private PortalType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortalType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortalType> knownValues() {
        EnumSet<PortalType> knownValues = EnumSet.allOf(PortalType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PortalType.class, PortalType::toString);
    }
}

