/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDatasetRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DeleteDatasetRequest> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(DeleteDatasetRequest.getter(DeleteDatasetRequest::datasetId)).setter(DeleteDatasetRequest.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteDatasetRequest.getter(DeleteDatasetRequest::clientToken)).setter(DeleteDatasetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datasetId", DATASET_ID_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String datasetId;
    private final String clientToken;

    private DeleteDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.clientToken = builder.clientToken;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDatasetRequest)) {
            return false;
        }
        DeleteDatasetRequest other = (DeleteDatasetRequest)((Object)obj);
        return Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDatasetRequest").add("DatasetId", (Object)this.datasetId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDatasetRequest, T> g) {
        return obj -> g.apply((DeleteDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String datasetId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDatasetRequest model) {
            super(model);
            this.datasetId(model.datasetId);
            this.clientToken(model.clientToken);
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDatasetRequest build() {
            return new DeleteDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDatasetRequest> {
        public Builder datasetId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

