/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ActionPayload;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.TargetResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActionResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeActionResponse> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(DescribeActionResponse.getter(DescribeActionResponse::actionId)).setter(DescribeActionResponse.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetResource").getter(DescribeActionResponse.getter(DescribeActionResponse::targetResource)).setter(DescribeActionResponse.setter(Builder::targetResource)).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()}).build();
    private static final SdkField<String> ACTION_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionDefinitionId").getter(DescribeActionResponse.getter(DescribeActionResponse::actionDefinitionId)).setter(DescribeActionResponse.setter(Builder::actionDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitionId").build()}).build();
    private static final SdkField<ActionPayload> ACTION_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionPayload").getter(DescribeActionResponse.getter(DescribeActionResponse::actionPayload)).setter(DescribeActionResponse.setter(Builder::actionPayload)).constructor(ActionPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPayload").build()}).build();
    private static final SdkField<Instant> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionTime").getter(DescribeActionResponse.getter(DescribeActionResponse::executionTime)).setter(DescribeActionResponse.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, TARGET_RESOURCE_FIELD, ACTION_DEFINITION_ID_FIELD, ACTION_PAYLOAD_FIELD, EXECUTION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionId", ACTION_ID_FIELD);
            this.put("targetResource", TARGET_RESOURCE_FIELD);
            this.put("actionDefinitionId", ACTION_DEFINITION_ID_FIELD);
            this.put("actionPayload", ACTION_PAYLOAD_FIELD);
            this.put("executionTime", EXECUTION_TIME_FIELD);
        }
    });
    private final String actionId;
    private final TargetResource targetResource;
    private final String actionDefinitionId;
    private final ActionPayload actionPayload;
    private final Instant executionTime;

    private DescribeActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionId = builder.actionId;
        this.targetResource = builder.targetResource;
        this.actionDefinitionId = builder.actionDefinitionId;
        this.actionPayload = builder.actionPayload;
        this.executionTime = builder.executionTime;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final TargetResource targetResource() {
        return this.targetResource;
    }

    public final String actionDefinitionId() {
        return this.actionDefinitionId;
    }

    public final ActionPayload actionPayload() {
        return this.actionPayload;
    }

    public final Instant executionTime() {
        return this.executionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionResponse)) {
            return false;
        }
        DescribeActionResponse other = (DescribeActionResponse)((Object)obj);
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.targetResource(), other.targetResource()) && Objects.equals(this.actionDefinitionId(), other.actionDefinitionId()) && Objects.equals(this.actionPayload(), other.actionPayload()) && Objects.equals(this.executionTime(), other.executionTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeActionResponse").add("ActionId", (Object)this.actionId()).add("TargetResource", (Object)this.targetResource()).add("ActionDefinitionId", (Object)this.actionDefinitionId()).add("ActionPayload", (Object)this.actionPayload()).add("ExecutionTime", (Object)this.executionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "targetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
            case "actionDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.actionDefinitionId()));
            }
            case "actionPayload": {
                return Optional.ofNullable(clazz.cast(this.actionPayload()));
            }
            case "executionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionResponse, T> g) {
        return obj -> g.apply((DescribeActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String actionId;
        private TargetResource targetResource;
        private String actionDefinitionId;
        private ActionPayload actionPayload;
        private Instant executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionResponse model) {
            super(model);
            this.actionId(model.actionId);
            this.targetResource(model.targetResource);
            this.actionDefinitionId(model.actionDefinitionId);
            this.actionPayload(model.actionPayload);
            this.executionTime(model.executionTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return this.targetResource != null ? this.targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getActionDefinitionId() {
            return this.actionDefinitionId;
        }

        public final void setActionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
        }

        @Override
        public final Builder actionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
            return this;
        }

        public final ActionPayload.Builder getActionPayload() {
            return this.actionPayload != null ? this.actionPayload.toBuilder() : null;
        }

        public final void setActionPayload(ActionPayload.BuilderImpl actionPayload) {
            this.actionPayload = actionPayload != null ? actionPayload.build() : null;
        }

        @Override
        public final Builder actionPayload(ActionPayload actionPayload) {
            this.actionPayload = actionPayload;
            return this;
        }

        public final Instant getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        @Override
        public DescribeActionResponse build() {
            return new DescribeActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActionResponse> {
        public Builder actionId(String var1);

        public Builder targetResource(TargetResource var1);

        default public Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return this.targetResource((TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation(targetResource)).build());
        }

        public Builder actionDefinitionId(String var1);

        public Builder actionPayload(ActionPayload var1);

        default public Builder actionPayload(Consumer<ActionPayload.Builder> actionPayload) {
            return this.actionPayload((ActionPayload)((ActionPayload.Builder)ActionPayload.builder().applyMutation(actionPayload)).build());
        }

        public Builder executionTime(Instant var1);
    }
}

