/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.BatchEntryCompletionStatus;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueErrorInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyValueSkippedEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetAssetPropertyValueSkippedEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchGetAssetPropertyValueSkippedEntry.getter(BatchGetAssetPropertyValueSkippedEntry::entryId)).setter(BatchGetAssetPropertyValueSkippedEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> COMPLETION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completionStatus").getter(BatchGetAssetPropertyValueSkippedEntry.getter(BatchGetAssetPropertyValueSkippedEntry::completionStatusAsString)).setter(BatchGetAssetPropertyValueSkippedEntry.setter(Builder::completionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionStatus").build()}).build();
    private static final SdkField<BatchGetAssetPropertyValueErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(BatchGetAssetPropertyValueSkippedEntry.getter(BatchGetAssetPropertyValueSkippedEntry::errorInfo)).setter(BatchGetAssetPropertyValueSkippedEntry.setter(Builder::errorInfo)).constructor(BatchGetAssetPropertyValueErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, COMPLETION_STATUS_FIELD, ERROR_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("entryId", ENTRY_ID_FIELD);
            this.put("completionStatus", COMPLETION_STATUS_FIELD);
            this.put("errorInfo", ERROR_INFO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String completionStatus;
    private final BatchGetAssetPropertyValueErrorInfo errorInfo;

    private BatchGetAssetPropertyValueSkippedEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.completionStatus = builder.completionStatus;
        this.errorInfo = builder.errorInfo;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final BatchEntryCompletionStatus completionStatus() {
        return BatchEntryCompletionStatus.fromValue(this.completionStatus);
    }

    public final String completionStatusAsString() {
        return this.completionStatus;
    }

    public final BatchGetAssetPropertyValueErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueSkippedEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueSkippedEntry other = (BatchGetAssetPropertyValueSkippedEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.completionStatusAsString(), other.completionStatusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyValueSkippedEntry").add("EntryId", (Object)this.entryId()).add("CompletionStatus", (Object)this.completionStatusAsString()).add("ErrorInfo", (Object)this.errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "completionStatus": {
                return Optional.ofNullable(clazz.cast(this.completionStatusAsString()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueSkippedEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueSkippedEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String completionStatus;
        private BatchGetAssetPropertyValueErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueSkippedEntry model) {
            this.entryId(model.entryId);
            this.completionStatus(model.completionStatus);
            this.errorInfo(model.errorInfo);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getCompletionStatus() {
            return this.completionStatus;
        }

        public final void setCompletionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
        }

        @Override
        public final Builder completionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        @Override
        public final Builder completionStatus(BatchEntryCompletionStatus completionStatus) {
            this.completionStatus(completionStatus == null ? null : completionStatus.toString());
            return this;
        }

        public final BatchGetAssetPropertyValueErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(BatchGetAssetPropertyValueErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(BatchGetAssetPropertyValueErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public BatchGetAssetPropertyValueSkippedEntry build() {
            return new BatchGetAssetPropertyValueSkippedEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyValueSkippedEntry> {
        public Builder entryId(String var1);

        public Builder completionStatus(String var1);

        public Builder completionStatus(BatchEntryCompletionStatus var1);

        public Builder errorInfo(BatchGetAssetPropertyValueErrorInfo var1);

        default public Builder errorInfo(Consumer<BatchGetAssetPropertyValueErrorInfo.Builder> errorInfo) {
            return this.errorInfo((BatchGetAssetPropertyValueErrorInfo)((BatchGetAssetPropertyValueErrorInfo.Builder)BatchGetAssetPropertyValueErrorInfo.builder().applyMutation(errorInfo)).build());
        }
    }
}

