/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.waiters.IoTSiteWiseWaiter;
import software.amazon.awssdk.services.iotsitewise.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultIoTSiteWiseWaiter
implements IoTSiteWiseWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final IoTSiteWiseClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeAssetModelResponse> assetModelNotExistsWaiter;
    private final Waiter<DescribeAssetModelResponse> assetModelActiveWaiter;
    private final Waiter<DescribeAssetResponse> assetNotExistsWaiter;
    private final Waiter<DescribeAssetResponse> assetActiveWaiter;
    private final Waiter<DescribePortalResponse> portalNotExistsWaiter;
    private final Waiter<DescribePortalResponse> portalActiveWaiter;

    private DefaultIoTSiteWiseWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (IoTSiteWiseClient)IoTSiteWiseClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.assetModelNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAssetModelResponse.class).acceptors(DefaultIoTSiteWiseWaiter.assetModelNotExistsWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseWaiter.assetModelNotExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.assetModelActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAssetModelResponse.class).acceptors(DefaultIoTSiteWiseWaiter.assetModelActiveWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseWaiter.assetModelActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.assetNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAssetResponse.class).acceptors(DefaultIoTSiteWiseWaiter.assetNotExistsWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseWaiter.assetNotExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.assetActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeAssetResponse.class).acceptors(DefaultIoTSiteWiseWaiter.assetActiveWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseWaiter.assetActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.portalNotExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribePortalResponse.class).acceptors(DefaultIoTSiteWiseWaiter.portalNotExistsWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseWaiter.portalNotExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.portalActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribePortalResponse.class).acceptors(DefaultIoTSiteWiseWaiter.portalActiveWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseWaiter.portalActiveWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeAssetResponse> waitUntilAssetActive(DescribeAssetRequest describeAssetRequest) {
        return this.assetActiveWaiter.run(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)));
    }

    @Override
    public WaiterResponse<DescribeAssetResponse> waitUntilAssetActive(DescribeAssetRequest describeAssetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetActiveWaiter.run(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)), DefaultIoTSiteWiseWaiter.assetActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAssetModelResponse> waitUntilAssetModelActive(DescribeAssetModelRequest describeAssetModelRequest) {
        return this.assetModelActiveWaiter.run(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)));
    }

    @Override
    public WaiterResponse<DescribeAssetModelResponse> waitUntilAssetModelActive(DescribeAssetModelRequest describeAssetModelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetModelActiveWaiter.run(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)), DefaultIoTSiteWiseWaiter.assetModelActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAssetModelResponse> waitUntilAssetModelNotExists(DescribeAssetModelRequest describeAssetModelRequest) {
        return this.assetModelNotExistsWaiter.run(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)));
    }

    @Override
    public WaiterResponse<DescribeAssetModelResponse> waitUntilAssetModelNotExists(DescribeAssetModelRequest describeAssetModelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetModelNotExistsWaiter.run(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)), DefaultIoTSiteWiseWaiter.assetModelNotExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeAssetResponse> waitUntilAssetNotExists(DescribeAssetRequest describeAssetRequest) {
        return this.assetNotExistsWaiter.run(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)));
    }

    @Override
    public WaiterResponse<DescribeAssetResponse> waitUntilAssetNotExists(DescribeAssetRequest describeAssetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetNotExistsWaiter.run(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)), DefaultIoTSiteWiseWaiter.assetNotExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribePortalResponse> waitUntilPortalActive(DescribePortalRequest describePortalRequest) {
        return this.portalActiveWaiter.run(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)));
    }

    @Override
    public WaiterResponse<DescribePortalResponse> waitUntilPortalActive(DescribePortalRequest describePortalRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.portalActiveWaiter.run(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)), DefaultIoTSiteWiseWaiter.portalActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribePortalResponse> waitUntilPortalNotExists(DescribePortalRequest describePortalRequest) {
        return this.portalNotExistsWaiter.run(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)));
    }

    @Override
    public WaiterResponse<DescribePortalResponse> waitUntilPortalNotExists(DescribePortalRequest describePortalRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.portalNotExistsWaiter.run(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)), DefaultIoTSiteWiseWaiter.portalNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeAssetModelResponse>> assetModelNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultIoTSiteWiseWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAssetModelResponse>> assetModelActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetModelStatus").field("state").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetModelStatus").field("state").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAssetResponse>> assetNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultIoTSiteWiseWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAssetResponse>> assetActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetStatus").field("state").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetStatus").field("state").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribePortalResponse>> portalNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribePortalResponse>> result = new ArrayList<WaiterAcceptor<? super DescribePortalResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultIoTSiteWiseWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribePortalResponse>> portalActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribePortalResponse>> result = new ArrayList<WaiterAcceptor<? super DescribePortalResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("portalStatus").field("state").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration assetModelNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration assetModelActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration assetNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration assetActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration portalNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration portalActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static IoTSiteWiseWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends IoTSiteWiseRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IoTSiteWiseRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements IoTSiteWiseWaiter.Builder {
        private IoTSiteWiseClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public IoTSiteWiseWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public IoTSiteWiseWaiter.Builder client(IoTSiteWiseClient client) {
            this.client = client;
            return this;
        }

        @Override
        public IoTSiteWiseWaiter build() {
            return new DefaultIoTSiteWiseWaiter(this);
        }
    }
}

