/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListPortalsResponse;
import software.amazon.awssdk.services.iotsitewise.model.PortalSummary;

public class ListPortalsIterable
implements SdkIterable<ListPortalsResponse> {
    private final IoTSiteWiseClient client;
    private final ListPortalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortalsIterable(IoTSiteWiseClient client, ListPortalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPortalsResponseFetcher();
    }

    public Iterator<ListPortalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PortalSummary> portalSummaries() {
        Function<ListPortalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.portalSummaries() != null) {
                return response.portalSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPortalsResponseFetcher
    implements SyncPageFetcher<ListPortalsResponse> {
        private ListPortalsResponseFetcher() {
        }

        public boolean hasNextPage(ListPortalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPortalsResponse nextPage(ListPortalsResponse previousPage) {
            if (previousPage == null) {
                return ListPortalsIterable.this.client.listPortals(ListPortalsIterable.this.firstRequest);
            }
            return ListPortalsIterable.this.client.listPortals((ListPortalsRequest)((Object)ListPortalsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

