/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TraversalDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedAssetsRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, ListAssociatedAssetsRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(ListAssociatedAssetsRequest.getter(ListAssociatedAssetsRequest::assetId)).setter(ListAssociatedAssetsRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()}).build();
    private static final SdkField<String> HIERARCHY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hierarchyId").getter(ListAssociatedAssetsRequest.getter(ListAssociatedAssetsRequest::hierarchyId)).setter(ListAssociatedAssetsRequest.setter(Builder::hierarchyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hierarchyId").build()}).build();
    private static final SdkField<String> TRAVERSAL_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traversalDirection").getter(ListAssociatedAssetsRequest.getter(ListAssociatedAssetsRequest::traversalDirectionAsString)).setter(ListAssociatedAssetsRequest.setter(Builder::traversalDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("traversalDirection").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedAssetsRequest.getter(ListAssociatedAssetsRequest::nextToken)).setter(ListAssociatedAssetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAssociatedAssetsRequest.getter(ListAssociatedAssetsRequest::maxResults)).setter(ListAssociatedAssetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, HIERARCHY_ID_FIELD, TRAVERSAL_DIRECTION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String assetId;
    private final String hierarchyId;
    private final String traversalDirection;
    private final String nextToken;
    private final Integer maxResults;

    private ListAssociatedAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.hierarchyId = builder.hierarchyId;
        this.traversalDirection = builder.traversalDirection;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String hierarchyId() {
        return this.hierarchyId;
    }

    public final TraversalDirection traversalDirection() {
        return TraversalDirection.fromValue(this.traversalDirection);
    }

    public final String traversalDirectionAsString() {
        return this.traversalDirection;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traversalDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedAssetsRequest)) {
            return false;
        }
        ListAssociatedAssetsRequest other = (ListAssociatedAssetsRequest)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.hierarchyId(), other.hierarchyId()) && Objects.equals(this.traversalDirectionAsString(), other.traversalDirectionAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedAssetsRequest").add("AssetId", (Object)this.assetId()).add("HierarchyId", (Object)this.hierarchyId()).add("TraversalDirection", (Object)this.traversalDirectionAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "hierarchyId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyId()));
            }
            case "traversalDirection": {
                return Optional.ofNullable(clazz.cast(this.traversalDirectionAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedAssetsRequest, T> g) {
        return obj -> g.apply((ListAssociatedAssetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetId;
        private String hierarchyId;
        private String traversalDirection;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedAssetsRequest model) {
            super(model);
            this.assetId(model.assetId);
            this.hierarchyId(model.hierarchyId);
            this.traversalDirection(model.traversalDirection);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getHierarchyId() {
            return this.hierarchyId;
        }

        public final void setHierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
        }

        @Override
        public final Builder hierarchyId(String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        public final String getTraversalDirection() {
            return this.traversalDirection;
        }

        public final void setTraversalDirection(String traversalDirection) {
            this.traversalDirection = traversalDirection;
        }

        @Override
        public final Builder traversalDirection(String traversalDirection) {
            this.traversalDirection = traversalDirection;
            return this;
        }

        @Override
        public final Builder traversalDirection(TraversalDirection traversalDirection) {
            this.traversalDirection(traversalDirection == null ? null : traversalDirection.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssociatedAssetsRequest build() {
            return new ListAssociatedAssetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedAssetsRequest> {
        public Builder assetId(String var1);

        public Builder hierarchyId(String var1);

        public Builder traversalDirection(String var1);

        public Builder traversalDirection(TraversalDirection var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

